#ifndef SHARINGDIALOG_H
#define SHARINGDIALOG_H

#include "abstractdialog.h"
#include "selectionmodels.h"
#include <QListView>
#include <QGridLayout>

class SharingDialog : public AbstractDialog
{
    Q_OBJECT

public:
    explicit SharingDialog(QWidget *parent = 0);
    Services::SharingService currentValue() const;

private:
    void setLandscapeLayout();
    void setPortraitLayout();

private slots:
    void onItemClicked(const QModelIndex &index);

signals:
    void valueChanged(Services::SharingService service);

private:
    SharingModel *m_model;
    QListView *m_listView;
    QGridLayout *m_grid;
};

#endif // SHARINGDIALOG_H
