#include "searchorderselector.h"

SearchOrderSelector::SearchOrderSelector(const QString &text, QWidget *parent) :
    QMaemo5ValueButton(text, parent),
    m_model(new SearchOrderModel(this)),
    m_selector(new QMaemo5ListPickSelector(this))
{
    m_selector->setModel(m_model);
    m_selector->setModelColumn(0);
    setPickSelector(m_selector);
    connect(m_selector, SIGNAL(selected(QString)), this, SLOT(onSelected()));
}

void SearchOrderSelector::setValue(Queries::QueryOrder value) {
    bool found = false;
    int i = 0;

    while ((!found) && (i < m_model->rowCount())) {
        found = static_cast<Queries::QueryOrder>(m_model->value(i).toInt()) == value;

        if (found) {
            m_selector->setCurrentIndex(i);
        }

        i++;
    }

    if (!found) {
        m_selector->setCurrentIndex(0);
    }
}

Queries::QueryOrder SearchOrderSelector::currentValue() {
    return static_cast<Queries::QueryOrder>(m_model->value(m_selector->currentIndex()).toInt());
}

void SearchOrderSelector::onSelected() {
    emit valueChanged(currentValue());
}
