#ifndef PLAYBACKQUEUEWINDOW_H
#define PLAYBACKQUEUEWINDOW_H

#include "stackedwindow.h"
#include "listview.h"
#include <QAction>
#include <QLabel>

class PlaybackQueueWindow : public StackedWindow
{
    Q_OBJECT
public:
    explicit PlaybackQueueWindow(Session *session, QWidget *parent = 0);

private:
    void setLandscapeLayout();
    void setPortraitLayout();
    void showYouTubeVideoInfo(QSharedPointer<VideoItem> video);
    void showDailymotionVideoInfo(QSharedPointer<VideoItem> video);
    void showVimeoVideoInfo(QSharedPointer<VideoItem> video);

private slots:
    void onCountChanged();
    void removeVideos();
    void addVideoDownloads();
    void addAudioDownloads();
    void onItemClicked(const QModelIndex &index);
    void playVideo(const QModelIndex &index);
    
private:
    ListView *m_listView;
    QAction *m_removeAction;
    QAction *m_videoDownloadAction;
    QAction *m_audioDownloadAction;
    QLabel *m_noResultsLabel;
};

#endif // PLAYBACKQUEUEWINDOW_H
