#ifndef DATABASE_H
#define DATABASE_H

#include "transferitem.h"
#include <QObject>
#include <QStringList>
#include <QtSql/QSqlDatabase>

class Database : public QObject {
    Q_OBJECT

public:
    explicit Database(QObject *parent = 0);
    ~Database() {}
    void restoreAccounts();

public slots:
    void initialize();
    void setDownloadPath(const QString &path);
    void setDefaultTransferStatus(int status);
    void getStoredDownloads();
    bool storeDownload(QSharedPointer<TransferItem> transfer);
    void removeStoredDownload(QSharedPointer<TransferItem> transfer);
    bool setYouTubeUsername(const QString &user);
    bool setYouTubeAccessToken(const QString &token);
    bool setYouTubeCookies(const QByteArray &cookieString);
    bool setDailymotionUsername(const QString &user);
    bool setDailymotionAccessToken(const QString &token, const QString &refresh);
    bool setDailymotionCookies(const QByteArray &cookieString);
    bool storeFacebookAccount(const QString &token);
    bool deleteFacebookAccount();
    bool storeTwitterAccount(const QString &token, const QString &secret);
    bool deleteTwitterAccount();

signals:
    void alert(const QString &message);
    void warning(const QString &message);
    void info(const QString &message);
    void storedDownloadRemoved(QSharedPointer<TransferItem> transfer);
    void gotStoredDownloads(QList< QSharedPointer<TransferItem> > transfers);
    void gotYouTubeAccount(const QString &user, const QString &token, const QString &refresh);
    void gotYouTubeCookies(const QByteArray &cookieString);
    void gotDailymotionAccount(const QString &user, const QString &token, const QString &refresh);
    void gotDailymotionCookies(const QByteArray &cookieString);
    void gotFacebookAccount(const QString &token);
    void gotTwitterAccount(const QString &token, const QString &secret);

private:
    void restoreYouTubeAccount();
    void restoreDailymotionAccount();
    void restoreFacebookAccount();
    void restoreTwitterAccount();

private:
    QSqlDatabase m_database;
    QString m_path;
    TransferItem::Status m_transferStatus;
};

#endif // DATABASE_H
