#ifndef DAILYMOTIONVIDEOLISTWINDOW_H
#define DAILYMOTIONVIDEOLISTWINDOW_H

#include "stackedwindow.h"
#include "dailymotionvideolistmodel.h"
#include "listview.h"
#include <QAction>
#include <QLabel>

class DailymotionVideoListWindow : public StackedWindow
{
    Q_OBJECT
public:
    explicit DailymotionVideoListWindow(Session *session, QWidget *parent);
    void setVideoFeed(const QString &feed);
    void getRelatedVideos(const QString &id);
    void getGroupVideos(QSharedPointer<GroupItem> group);
    void search(const QString &query, Queries::QueryOrder order, const QString &language);

private:
    void setLandscapeLayout();
    void setPortraitLayout();

private slots:
    void setMenuActions();
    void onLoadingChanged();
    void toggleGroupMembership();
    void deleteVideosFromUploads();
    void addVideosToFavourites();
    void deleteVideosFromFavourites();
    void addVideosToPlaylist();
    void addVideoDownloads();
    void addAudioDownloads();
    void queueVideos();
    void onItemClicked(const QModelIndex &index);
    void showVideoInfo(QSharedPointer<VideoItem> video);
    void playVideo(const QModelIndex &index);

private:
    ListView *m_listView;
    DailymotionVideoListModel *m_model;
    QSharedPointer<GroupItem> m_group;
    QAction *m_groupAction;
    QAction *m_deleteFromUploadsAction;
    QAction *m_addToFavouritesAction;
    QAction *m_deleteFromFavouritesAction;
    QAction *m_addToPlaylistAction;
    QAction *m_addToQueueAction;
    QAction *m_videoDownloadAction;
    QAction *m_audioDownloadAction;
    QLabel *m_noResultsLabel;
};

#endif // DAILYMOTIONVIDEOLISTWINDOW_H
