#ifndef CATEGORIESDIALOG_H
#define CATEGORIESDIALOG_H

#include "abstractdialog.h"
#include "youtubecategorymodel.h"
#include "dailymotioncategorymodel.h"
#include "listview.h"
#include "separatorlabel.h"
#include <QGridLayout>

class CategoriesDialog : public AbstractDialog
{
    Q_OBJECT

public:
    explicit CategoriesDialog(QWidget *parent = 0);
    
private:
    void setLandscapeLayout();
    void setPortraitLayout();

private slots:
    void onYouTubeCategoryChosen(const QModelIndex &index);
    void onDailymotionCategoryChosen(const QModelIndex &index);

signals:
    void categoryChosen(Services::VideoService service, const QString &title, const QString &feed);

private:
    SeparatorLabel *m_youtubeLabel;
    SeparatorLabel *m_dailymotionLabel;
    YouTubeCategoryModel *m_youtubeModel;
    DailymotionCategoryModel *m_dailymotionModel;
    ListView *m_youtubeView;
    ListView *m_dailymotionView;
    QGridLayout *m_grid;
};

#endif // CATEGORIESDIALOG_H
