#include "abstracttab.h"

AbstractTab::AbstractTab(QWidget *parent) :
    QWidget(parent),
    m_portrait(false)
{
    connect(QApplication::desktop(), SIGNAL(resized(int)), this, SLOT(onOrientationChanged()));
}

void AbstractTab::onOrientationChanged() {
    QRect screen = QApplication::desktop()->screenGeometry();

    if (screen.width() > screen.height()) {
        m_portrait = false;
        setLandscapeLayout();
    }
    else {
        m_portrait = true;
        setPortraitLayout();
    }
}
