#include "transferpriorityselector.h"
#include "../base/selectionmodels.h"
#include <QMaemo5ListPickSelector>

TransferPrioritySelector::TransferPrioritySelector(const QString &text, QWidget *parent) :
    QMaemo5ValueButton(text, parent),
    m_model(new TransferPriorityModel(this)),
    m_selector(new QMaemo5ListPickSelector(this))
{
    m_selector->setModel(m_model);
    m_selector->setModelColumn(0);
    this->setPickSelector(m_selector);
    this->connect(m_selector, SIGNAL(selected(QString)), this, SLOT(onSelected()));
}

void TransferPrioritySelector::setValue(Transfers::Priority value) {
    bool found = false;
    int i = 0;

    while ((!found) && (i < m_model->rowCount())) {
        found = static_cast<Transfers::Priority>(m_model->value(i).toInt()) == value;

        if (found) {
            m_selector->setCurrentIndex(i);
        }

        i++;
    }

    if (!found) {
        m_selector->setCurrentIndex(0);
    }
}

Transfers::Priority TransferPrioritySelector::currentValue() {
    return static_cast<Transfers::Priority>(m_model->value(m_selector->currentIndex()).toInt());
}

void TransferPrioritySelector::onSelected() {
    emit valueChanged(this->currentValue());
}
