#include "vimeouseralbumlistmodel.h"
#include "vimeo.h"
#ifndef QML_USER_INTERFACE
#include "thumbnailcache.h"
#endif

VimeoUserAlbumListModel::VimeoUserAlbumListModel(QObject *parent) :
    QAbstractListModel(parent)
  #ifndef QML_USER_INTERFACE
    ,m_cache(new ThumbnailCache)
  #endif
{
    m_roleNames[IdRole] = "id";
    m_roleNames[AlbumIdRole] = "albumId";
    m_roleNames[TitleRole] = "title";
    m_roleNames[ArtistRole] = "artist";
    m_roleNames[DateRole] = "date";
    m_roleNames[VideoCountRole] = "videoCount";
#ifndef QML_USER_INTERFACE
    m_roleNames[ThumbnailRole] = "thumbnail";
#endif
    m_roleNames[ThumbnailUrlRole] = "thumbnailUrl";
    m_roleNames[LargeThumbnailUrlRole] = "largeThumbnailUrl";
    m_roleNames[DescriptionRole] = "description";
#if QT_VERSION < 0x050000
    this->setRoleNames(m_roleNames);
#endif

#ifndef QML_USER_INTERFACE
    this->connect(m_cache, SIGNAL(thumbnailReady()), this, SLOT(onThumbnailReady()));
#endif
    if (!Vimeo::instance()->albumsLoaded()) {
        Vimeo::instance()->getAlbums();
    }

    this->connect(Vimeo::instance(), SIGNAL(albumAddedToCache(int)), this, SLOT(onAlbumAdded(int)));
    this->connect(Vimeo::instance(), SIGNAL(albumRemovedFromCache(int)), this, SLOT(onAlbumRemoved(int)));
    this->connect(Vimeo::instance(), SIGNAL(albumUpdated(int)), this, SLOT(onAlbumUpdated(int)));
}

VimeoUserAlbumListModel::~VimeoUserAlbumListModel() {
#ifndef QML_USER_INTERFACE
    delete m_cache;
    m_cache = 0;
#endif
}

#if QT_VERSION >= 0x050000
QHash<int, QByteArray> VimeoUserAlbumListModel::roleNames() const {
    return m_roleNames;
}
#endif

void VimeoUserAlbumListModel::onAlbumAdded(int row) {
    this->beginInsertRows(QModelIndex(), row, row);
    this->endInsertRows();
    emit countChanged(this->rowCount());
}

void VimeoUserAlbumListModel::onAlbumRemoved(int row) {
    this->beginRemoveRows(QModelIndex(), row, row);
    this->endRemoveRows();
    emit countChanged(this->rowCount());
}

void VimeoUserAlbumListModel::onAlbumUpdated(int row) {
    emit dataChanged(this->index(row), this->index(row));
}

int VimeoUserAlbumListModel::rowCount(const QModelIndex &parent) const {
    Q_UNUSED(parent)

    return Vimeo::instance()->albums()->size();
}

QVariant VimeoUserAlbumListModel::data(const QModelIndex &index, int role) const {
    switch (role) {
    case IdRole:
        return Vimeo::instance()->albums()->at(index.row()).data()->id();
    case AlbumIdRole:
        return Vimeo::instance()->albums()->at(index.row()).data()->playlistId();
    case TitleRole:
        return Vimeo::instance()->albums()->at(index.row()).data()->title();
    case ArtistRole:
        return Vimeo::instance()->albums()->at(index.row()).data()->artist();
    case DateRole:
        return Vimeo::instance()->albums()->at(index.row()).data()->date();
    case VideoCountRole:
        return Vimeo::instance()->albums()->at(index.row()).data()->videoCount();
#ifndef QML_USER_INTERFACE
    case ThumbnailRole:
        return m_cache->thumbnail(Vimeo::instance()->albums()->at(index.row()).data()->thumbnailUrl(), QSize(120, 90));
#endif
    case ThumbnailUrlRole:
        return Vimeo::instance()->albums()->at(index.row()).data()->thumbnailUrl();
    case LargeThumbnailUrlRole:
        return Vimeo::instance()->albums()->at(index.row()).data()->largeThumbnailUrl();
    case DescriptionRole:
        return Vimeo::instance()->albums()->at(index.row()).data()->description();
    default:
        return QVariant();
    }
}

QVariant VimeoUserAlbumListModel::data(int row, const QByteArray &role) const {
    return this->data(this->index(row), this->roleNames().key(role));
}

QSharedPointer<PlaylistItem> VimeoUserAlbumListModel::get(int row) const {
    return QSharedPointer<PlaylistItem>(Vimeo::instance()->albums()->at(row));
}

#ifdef QML_USER_INTERFACE
PlaylistItem* VimeoUserAlbumListModel::getFromQML(int row) const {
    return Vimeo::instance()->albums()->at(row).data();
}
#endif

#ifndef QML_USER_INTERFACE
void VimeoUserAlbumListModel::onThumbnailReady() {
    emit dataChanged(this->index(0), this->index(this->rowCount() - 1));
}
#endif
