#ifndef YOUTUBEUSERPLAYLISTLISTMODEL_H
#define YOUTUBEUSERPLAYLISTLISTMODEL_H

#include "playlistitem.h"
#include <QAbstractListModel>
#include <QSharedPointer>

#ifndef QML_USER_INTERFACE
class ThumbnailCache;
#endif

class YouTubeUserPlaylistListModel : public QAbstractListModel
{
    Q_OBJECT

    Q_PROPERTY(int count
               READ rowCount
               NOTIFY countChanged)

public:
    enum Roles {
        IdRole = Qt::UserRole + 1,
        PlaylistIdRole,
        TitleRole,
        ArtistRole,
        ArtistAvatarUrlRole,
        DateRole,
        VideoCountRole,
#ifndef QML_USER_INTERFACE
        ThumbnailRole,
#endif
        ThumbnailUrlRole,
        LargeThumbnailUrlRole,
        DescriptionRole
    };

public:
    explicit YouTubeUserPlaylistListModel(QObject *parent = 0);
    ~YouTubeUserPlaylistListModel();
#if QT_VERSION >= 0x050000
    QHash<int, QByteArray> roleNames() const;
#endif
    int rowCount(const QModelIndex &parent = QModelIndex()) const;
    QVariant data(const QModelIndex &index, int role = Qt::DisplayRole) const;
    Q_INVOKABLE QVariant data(int row, const QByteArray &role) const;
    QSharedPointer<PlaylistItem> get(int row) const;
#ifdef QML_USER_INTERFACE
    Q_INVOKABLE PlaylistItem* getFromQML(int row) const;
#endif

private slots:
    void onPlaylistAdded(int row);
    void onPlaylistRemoved(int row);
    void onPlaylistUpdated(int row);
#ifndef QML_USER_INTERFACE
    void onThumbnailReady();
#endif

signals:
    void countChanged(int count);

private:
#ifndef QML_USER_INTERFACE
    ThumbnailCache *m_cache;
#endif
    QHash<int, QByteArray> m_roleNames;
};

#endif // YOUTUBEUSERPLAYLISTLISTMODEL_H
