TEMPLATE = app
QT += network sql xml script
TARGET = cutetube

INSTALLS += target

SOURCES = $$files(src/base/*.cpp)
HEADERS = $$files(src/base/*.h)

contains(DEFINES,SAILFISH_OS) {
    DEFINES += QML_USER_INTERFACE CUTETUBE_PLAYER_ENABLED
    QT += quick dbus docgallery
    SOURCES += $$files(src/sailfish/*.cpp)
    HEADERS += $$files(src/sailfish/*.h)
    RESOURCES = qml/sailfish/resources.qrc

#    OTHER_FILES += $$files(qml/sailfish/*.*)

    desktop_file.path = /usr/share/applications
    desktop_file.files = desktop/sailfish/cutetube.desktop

    icon80.path = /usr/share/icons/hicolor/80x80/apps
    icon80.files = desktop/sailfish/cutetube80.png

    icon64.path = /usr/share/icons/hicolor/64x64/apps
    icon64.files = desktop/sailfish/cutetube64.png

    dbus_service.files = dbus/sailfish/com.maemo.cuteTube.service
    dbus_service.path = /usr/share/dbus-1/services
    dbus_interface.files = dbus/sailfish/com.maemo.cuteTube.xml
    dbus_interface.path = /usr/share/dbus-1/interfaces

    contentaction.files = contentaction/cutetube.xml
    contentaction.path = /usr/share/contentaction

    target.path = /usr/bin

    include(src/sailfish/sailfishapplication/sailfishapplication.pri)

    INSTALLS += desktop_file icon80 icon64 dbus_service dbus_interface contentaction
}

maemo5 {
    system(lupdate src/base/*.* src/maemo5_gui/*.* -ts translations/maemo5_gui/base.ts)
    system(cp translations/maemo5_gui/base.ts translations/maemo5_gui/en.ts)
    system(lrelease translations/maemo5_gui/en.ts)

    DEFINES += CUTETUBE_PLAYER_ENABLED
    QT += maemo5 dbus webkit
    CONFIG += mobility12
    MOBILITY += multimedia
    SOURCES += $$files(src/maemo5_gui/*.cpp)
    HEADERS += $$files(src/maemo5_gui/*.h)
    RESOURCES = src/maemo5_gui/resources.qrc

    desktopfile.path = /usr/share/applications/hildon
    desktopfile.files = desktop/maemo5/cutetube.desktop

    icon.path = /usr/share/icons/hicolor/64x64/apps
    icon.files = desktop/maemo5/cutetube64.png

    translations.files += $$files(translations/maemo5_gui/*.*)
    translations.path += /opt/cutetube/translations

    dbus_service.files += dbus/maemo5/com.maemo.cuteTube.service
    dbus_service.path = /usr/share/dbus-1/services
    dbus_interface.files += dbus/maemo5/com.maemo.cuteTube.xml
    dbus_interface.path = /usr/share/dbus-1/interfaces

    target.path = /opt/cutetube/bin

    INSTALLS += translations desktopfile icon dbus_service dbus_interface
}

symbian {
    QT += declarative
    DEFINES += QML_USER_INTERFACE SYMBIAN_OS IN_APP_UPDATES
    MMP_RULES += "DEBUGGABLE_UDEBONLY"
    TARGET = cutetube_0xe561674e
    CONFIG += qt-components mobility
    MOBILITY += gallery systeminfo
    TARGET.EPOCHEAPSIZE = 0x20000 0x8000000
    TARGET.EPOCSTACKSIZE = 0x14000
    TARGET.CAPABILITY += NetworkServices ReadUserData
    TARGET.UID3 = 0xE561674E //0x20068c69
    DEPLOYMENT.display_name = cuteTube
    VERSION = 1.10.8
    ICON = desktop/symbian/cutetube.svg

    vendorinfo += "%{\"Stuart Howarth\"}" ":\"Stuart Howarth\""
    stupidnokia = "; Default dependency to Qt Quick Components for Symbian library" \
        "(0x200346DE), 1, 1, 0, {\"Qt Quick components for Symbian\"}"

    my_deployment.pkg_prerules += vendorinfo stupidnokia

    DEPLOYMENT += my_deployment

    SOURCES += $$files(src/symbian/*.cpp)
    HEADERS += $$files(src/symbian/*.h)
    RESOURCES = qml/symbian/resources.qrc
#    OTHER_FILES += $$files(qml/symbian/*.*)
}

contains(MEEGO_EDITION,harmattan) {
    DEFINES += QML_USER_INTERFACE CUTETUBE_PLAYER_ENABLED IN_APP_UPDATES
    QT+= opengl dbus declarative
    CONFIG += qdeclarative-boostable \
        libtuiclient \
        libcontentaction \
        shareuiinterface-maemo-meegotouch \
        share-ui-plugin \
        share-ui-common \
        mdatauri \
        mobility \
        qmsystem2

    MOBILITY += gallery
    SOURCES += $$files(src/harmattan/*.cpp)
    HEADERS += $$files(src/harmattan/*.h)
    RESOURCES = qml/harmattan/resources.qrc

    OTHER_FILES += $$files(qml/harmattan/*.*)

    desktop_file.path = /usr/share/applications
    desktop_file.files = desktop/harmattan/cutetube.desktop

    icon80.path = /usr/share/icons/hicolor/80x80/apps
    icon80.files = desktop/harmattan/cutetube80.png

    icon64.path = /usr/share/icons/hicolor/64x64/apps
    icon64.files = desktop/harmattan/cutetube64.png

    dbus_service.files = dbus/harmattan/com.maemo.cuteTube.service
    dbus_service.path = /usr/share/dbus-1/services
    dbus_interface.files = dbus/harmattan/com.maemo.cuteTube.xml
    dbus_interface.path = /usr/share/dbus-1/interfaces

    contentaction.files = contentaction/cutetube.xml
    contentaction.path = /usr/share/contentaction

    target.path = /opt/cutetube/bin

    resources.files += $$files(resources/*.*)
    resources.path = /opt/cutetube/resources

    launcher.files = desktop/harmattan/launcher.sh
    launcher.path = /opt/cutetube/bin

    INSTALLS += desktop_file icon80 icon64 dbus_service dbus_interface contentaction resources launcher
}

#unix {
#    DEFINES += QML_USER_INTERFACE CUTETUBE_PLAYER_ENABLED
#    QT += opengl dbus declarative
#    CONFIG += mobility
#    MOBILITY += gallery systeminfo
#    SOURCES += $$files(src/tv/*.cpp) $$files(src/qml/*.cpp)
#    HEADERS += $$files(src/tv/*.h) $$files(src/qml/*.h)
#    RESOURCES = qml/tv/resources.qrc
#    OTHER_FILES += $$files(qml/tv/720/*.*) $$files(qml/tv/1080/*.*) $$files(qml/tv/base/*.*)

#    desktopfile.path = /usr/share/applications/
#    desktopfile.files = desktop/tv/cutetube.desktop

#    icon.path = /usr/share/icons/hicolor/64x64/apps
#    icon.files = desktop/cutetube64.png

#    dbus_service.files += dbus/tv/com.maemo.cuteTube.service
#    dbus_service.path = /usr/share/dbus-1/services
#    dbus_interface.files += dbus/tv/com.maemo.cuteTube.xml
#    dbus_interface.path = /usr/share/dbus-1/interfaces

#    keyboard.files += $$files(src/tv/keyboard_layouts/*.xml)
#    keyboard.path = /opt/cutetube/keyboard_layouts

#    target.path = /opt/cutetube/bin

#    INSTALLS += desktopfile icon dbus_service dbus_interface keyboard
#}

simulator {
    QT += declarative
    DEFINES += SYMBIAN_OS QML_USER_INTERFACE IN_APP_UPDATES
    CONFIG += qt-components mobility
    MOBILITY += gallery systeminfo

    SOURCES += $$files(src/symbian/*.cpp)
    HEADERS += $$files(src/symbian/*.h)
    RESOURCES = qml/symbian/resources.qrc
    OTHER_FILES += $$files(qml/symbian/*.*)
}

contains(DEFINES,IN_APP_UPDATES) {
    HEADERS += src/updatemanager/updatemanager.h
    SOURCES += src/updatemanager/updatemanager.cpp
}
