#include "dailymotionusergrouplisttab.h"
#include "dailymotiongrouplistdelegate.h"
#include "dailymotionvideolistwindow.h"
#include "listview.h"
#include "../base/dailymotionusergrouplistmodel.h"
#include "../base/dailymotion.h"
#include "../base/notifications.h"
#include "windowstack.h"
#include <QLabel>
#include <QMenu>
#include <QAction>
#include <QGridLayout>
#include <QMaemo5Style>

DailymotionUserGroupListTab::DailymotionUserGroupListTab(QWidget *parent) :
    AbstractTab(parent),
    m_listView(new ListView(this)),
    m_model(new DailymotionUserGroupListModel(this)),
    m_contextMenu(new QMenu(this)),
    m_leaveAction(m_contextMenu->addAction(tr("Leave group"), this, SLOT(leaveGroup()))),
    m_noResultsLabel(new QLabel(QString("<p style='color:%1;font-size:40px;'><center><b>%2</b></center></p>").arg(QMaemo5Style::standardColor("SecondaryTextColor").name()).arg(tr("No groups found")), this)),
    m_grid(new QGridLayout(this))
{
    m_grid->setContentsMargins(0, 0, 0, 0);
    m_grid->addWidget(m_listView, 0, 0);
    m_listView->setItemDelegate(new DailymotionGroupListDelegate(m_listView));
    m_noResultsLabel->hide();

    if (Dailymotion::instance()->groupsLoaded()) {
        this->onGroupsLoaded();
    }
    else {
        Notifications::toggleBusy(true);
        this->connect(Dailymotion::instance(), SIGNAL(allGroupsLoaded()), this, SLOT(onGroupsLoaded()));
    }

    this->connect(m_model, SIGNAL(countChanged(int)), this, SLOT(onCountChanged(int)));

    this->onOrientationChanged();
}

void DailymotionUserGroupListTab::setLandscapeLayout() {
    m_noResultsLabel->setFixedSize(800, 400);
}

void DailymotionUserGroupListTab::setPortraitLayout() {
    m_noResultsLabel->setFixedSize(480, 700);
}

void DailymotionUserGroupListTab::onGroupsLoaded() {
    Notifications::toggleBusy(false);
    m_noResultsLabel->setVisible(m_model->rowCount() == 0);
    m_listView->setModel(m_model);

    this->connect(m_listView, SIGNAL(clicked(QModelIndex)), this, SLOT(onItemClicked(QModelIndex)));
    this->connect(m_listView, SIGNAL(customContextMenuRequested(QPoint)), this, SLOT(showContextMenu(QPoint)));
}

void DailymotionUserGroupListTab::onCountChanged(int count) {
    m_noResultsLabel->setVisible(count == 0);
}

void DailymotionUserGroupListTab::onItemClicked(const QModelIndex &index) {
    if (index.isValid()) {
        this->showGroup(m_model->get(index.row()));
    }
}

void DailymotionUserGroupListTab::showGroup(QSharedPointer<GroupItem> group) {
    DailymotionVideoListWindow *window = new DailymotionVideoListWindow(WindowStack::instance()->currentWindow());
    window->setWindowTitle(group.data()->title());
    window->getGroupVideos(group);
    window->show();
}

void DailymotionUserGroupListTab::showContextMenu(const QPoint &pos) {
    m_contextMenu->popup(pos, m_leaveAction);
}

void DailymotionUserGroupListTab::leaveGroup() {
    Dailymotion::instance()->leaveGroup(m_model->data(m_listView->currentIndex(), DailymotionUserGroupListModel::IdRole).toString());
}
