#include "dailymotionplaylistlistwindow.h"
#include "dailymotionplaylistvideoswindow.h"
#include "dailymotionplaylistdelegate.h"
#include "../base/dailymotionplaylistlistmodel.h"
#include "listview.h"
#include <QLabel>
#include <QMaemo5Style>

DailymotionPlaylistListWindow::DailymotionPlaylistListWindow(QWidget *parent) :
    StackedWindow(parent),
    m_listView(new ListView(this)),
    m_model(new DailymotionPlaylistListModel(this)),
    m_noResultsLabel(new QLabel(QString("<p style='color:%1;font-size:40px;'><center><b>%2</b></center></p>").arg(QMaemo5Style::standardColor("SecondaryTextColor").name()).arg(tr("No playlists found")), this))
{
    this->setCentralWidget(m_listView);

    m_listView->setModel(m_model);
    m_listView->setItemDelegate(new DailymotionPlaylistDelegate(m_listView));
    m_noResultsLabel->hide();

    this->connect(m_model, SIGNAL(loadingChanged(bool)), this, SLOT(onLoadingChanged(bool)));
    this->connect(m_model, SIGNAL(countChanged(int)), this, SLOT(onCountChanged(int)));
    this->connect(m_listView, SIGNAL(clicked(QModelIndex)), this, SLOT(onItemClicked(QModelIndex)));

    this->onOrientationChanged();
}

void DailymotionPlaylistListWindow::setLandscapeLayout() {
    m_noResultsLabel->setFixedSize(800, 400);
}

void DailymotionPlaylistListWindow::setPortraitLayout() {
    m_noResultsLabel->setFixedSize(480, 700);
}

void DailymotionPlaylistListWindow::setPlaylistFeed(const QUrl &feed) {
    m_model->setFeed(feed);
}

void DailymotionPlaylistListWindow::search(const QString &query, Queries::QueryOrder order) {
    this->setWindowTitle(tr("Search") + QString(" ('%1')").arg(query));
    m_model->search(query, order);
}

void DailymotionPlaylistListWindow::onLoadingChanged(bool loading) {
    this->toggleBusy(loading);
    m_noResultsLabel->setVisible((!loading) && (m_model->rowCount() == 0));
}

void DailymotionPlaylistListWindow::onCountChanged(int count) {
    m_noResultsLabel->setVisible((count == 0) && (!m_model->loading()));
}

void DailymotionPlaylistListWindow::onItemClicked(const QModelIndex &index) {
    if (index.isValid()) {
        this->showPlaylist(m_model->get(index.row()));
    }
}

void DailymotionPlaylistListWindow::showPlaylist(QSharedPointer<PlaylistItem> playlist) {
    DailymotionPlaylistVideosWindow *window = new DailymotionPlaylistVideosWindow(playlist, this);
    window->show();
}
