#ifndef VIMEOALBUMLISTTAB_H
#define VIMEOALBUMLISTTAB_H

#include "abstracttab.h"
#include "../base/playlistitem.h"

class ListView;
class VimeoAlbumListModel;
class QLabel;
class QGridLayout;
class QModelIndex;

class VimeoAlbumListTab : public AbstractTab
{
    Q_OBJECT

public:
    explicit VimeoAlbumListTab(QWidget *parent = 0);
    void setAlbumFeed(const QUrl &feed);

private:
    void setLandscapeLayout();
    void setPortraitLayout();

private slots:
    void onLoadingChanged(bool loading);
    void onCountChanged(int count);
    void onItemClicked(const QModelIndex &index);
    void showAlbum(QSharedPointer<PlaylistItem> album);

private:
    ListView *m_listView;
    VimeoAlbumListModel *m_model;
    QLabel *m_noResultsLabel;
    QGridLayout *m_grid;
};

#endif // VIMEOALBUMLISTTAB_H
