#ifndef ARCHIVELISTMODEL_H
#define ARCHIVELISTMODEL_H

#include "../base/videoitem.h"
#include <QSortFilterProxyModel>
#include <QSharedPointer>

class QFileSystemModel;

class ArchiveListModel : public QSortFilterProxyModel
{
    Q_OBJECT

    Q_PROPERTY(int count
               READ rowCount
               NOTIFY countChanged)
    Q_PROPERTY(QString query
               READ query
               WRITE setQuery
               NOTIFY queryChanged)
    Q_PROPERTY(QModelIndex rootIndex
               READ rootIndex
               CONSTANT)
    Q_PROPERTY(QString highlightColor
               READ highlightColor
               WRITE setHighlightColor)

public:
    enum Roles {
        FilePathRole = Qt::UserRole + 1,
        TitleRole,
        TitleMatchRole,
        DateRole,
        DateStringRole,
        ThumbnailPathRole,
        SubtitlesPathRole,
        UrlRole
    };

public:
    explicit ArchiveListModel(QObject *parent = 0);
    QHash<int, QByteArray> roleNames() const;
    QString regexMatch(QString str) const;
    inline QString query() const { return m_query; }
    QVariant data(const QModelIndex &index, int role) const;
    Q_INVOKABLE QVariant data(int row, const QByteArray &role) const;
    QSharedPointer<VideoItem> get(const QModelIndex &index) const;
#ifdef QML_USER_INTERFACE
    Q_INVOKABLE VideoItem* getFromQML(int row) const;
#endif
    QModelIndex rootIndex() const;
    bool filterAcceptsRow(int source_row, const QModelIndex &source_parent) const;
    inline QString highlightColor() const { return m_highlight; }
    inline void setHighlightColor(const QString &color) { m_highlight = color; }

public slots:
    void setQuery(const QString &query);
    void deleteVideo(const QModelIndex &index);

signals:
    void alert(const QString &message);
    void error(const QString &message);
    void directoryLoaded(const QString &path);
    void countChanged(int count);
    void queryChanged(const QString &query);

private:
    QFileSystemModel *m_model;
    QString m_query;
    QString m_highlight;
    QHash<int, QByteArray> m_roleNames;
};

#endif // ARCHIVELISTMODEL_H
