#include "vimeoalbumlistmodel.h"
#include "feedurls.h"
#include "vimeo.h"
#include <QNetworkReply>
#include <QNetworkRequest>

VimeoAlbumListModel::VimeoAlbumListModel(QObject *parent) :
    AbstractPlaylistListModel(parent),
    m_loading(true),
    m_moreResults(true),
    m_error(false),
    m_offset(1)
{
}

void VimeoAlbumListModel::clear() {
    AbstractPlaylistListModel::clear();
    this->setLoading(false);
    this->setOffset(1);
    this->setMoreResults(true);
    this->setError(false);
}

void VimeoAlbumListModel::reset() {
    if (!this->loading()) {
        this->clear();
        this->getMoreAlbums();
    }
}

void VimeoAlbumListModel::setFeed(const QUrl &feed) {
    if (feed != this->feed()) {
        m_feed = feed;
    }
}

void VimeoAlbumListModel::getAlbums(QUrl feed) {
    if (!feed.isEmpty()) {
        this->setFeed(feed);
    }

    this->setLoading(true);
    QNetworkReply *reply = Vimeo::instance()->createReply(this->feed(), this->offset());
    reply->setParent(this);
    this->connect(reply, SIGNAL(finished()), this, SLOT(addAlbums()));
}

void VimeoAlbumListModel::addAlbums() {
    QNetworkReply *reply = qobject_cast<QNetworkReply*>(this->sender());

    if (!reply) {
        this->setLoading(false);
        this->setError(true);
        return;
    }

    QDomDocument doc;
    doc.setContent(reply->readAll());
    QDomElement responseNode = doc.firstChildElement("rsp");

    if (responseNode.attribute("stat") == "ok") {
        QDomNodeList entries = doc.elementsByTagName("album");

        for (int i = 0; i < entries.size(); i++) {
            PlaylistItem *playlist = new PlaylistItem;
            playlist->loadVimeoAlbum(entries.at(i).toElement());
            QMetaObject::invokeMethod(this, "appendPlaylist", Q_ARG(QSharedPointer<PlaylistItem>, QSharedPointer<PlaylistItem>(playlist)));
        }

        QDomElement statNode = responseNode.firstChildElement("albums");

        this->setLoading(false);
        this->setMoreResults(statNode.attribute("total").toInt() > this->rowCount());
        this->setOffset(statNode.attribute("page").toInt() + 1);

        emit countChanged(this->rowCount());
    }
    else {
        this->setLoading(false);
        this->setError(true);
    }

    reply->deleteLater();
}

void VimeoAlbumListModel::getMoreAlbums() {
    if ((this->moreResults()) && (!this->loading())) {
        this->getAlbums();
    }
}
