#include "videoselectiondelegate.h"
#include "../base/utils.h"
#include "../base/abstractvideolistmodel.h"
#include <QApplication>
#include <QPainter>
#include <QMaemo5Style>

VideoSelectionDelegate::VideoSelectionDelegate(QObject *parent) :
    QStyledItemDelegate(parent)
{
}

void VideoSelectionDelegate::paint(QPainter *painter, const QStyleOptionViewItem &option, const QModelIndex &index) const {
    painter->save();

    bool checked = index.data(AbstractVideoListModel::SelectedRole).toBool();

    if (((option.state) & (QStyle::State_Selected)) || (checked)) {
        painter->drawImage(option.rect, QImage("/etc/hildon/theme/images/TouchListBackgroundPressed.png"));
    }
    else {
        painter->drawImage(option.rect, QImage("/etc/hildon/theme/images/TouchListBackgroundNormal.png"));
    }

    if (checked) {
        QRect checkRect = option.rect;
        checkRect.moveLeft(checkRect.right() - 53);
        checkRect.moveTop(checkRect.top() + 53);
        checkRect.setWidth(48);
        checkRect.setHeight(48);
        painter->drawImage(checkRect, QImage("/usr/share/icons/hicolor/48x48/hildon/widgets_tickmark_grid.png"));
    }

    QRect titleRect = option.rect;
    titleRect.setLeft(titleRect.left() + 170);
    titleRect.setRight(checked ? titleRect.right() - 58 : titleRect.right() - 5);
    titleRect.setTop(titleRect.top() + 5);
    titleRect.setHeight(60);

    painter->drawText(titleRect, Qt::TextWordWrap, index.data(AbstractVideoListModel::TitleRole).toString());

    QFont smallFont;
    smallFont.setPixelSize(18);
    painter->setFont(smallFont);
    painter->setPen(QMaemo5Style::standardColor("SecondaryTextColor"));

    QRect infoRect = option.rect;
    infoRect.setLeft(titleRect.left());
    infoRect.setRight(titleRect.right());
    infoRect.setBottom(infoRect.bottom() - 5);

    QString ratingText = QString("%1%  like  %2  views").arg(index.data(AbstractVideoListModel::RatingRole).toInt()).arg(index.data(AbstractVideoListModel::ViewCountRole).toInt());
    painter->drawText(infoRect, Qt::AlignBottom, ratingText);

    infoRect.setBottom(infoRect.bottom() - 25);

    QString artistText = QString("%1 - %2").arg(index.data(AbstractVideoListModel::ArtistRole).toString(), index.data(AbstractVideoListModel::DateRole).toString());

    painter->drawText(infoRect, Qt::TextWordWrap | Qt::AlignBottom, artistText);

    QRect imageRect = option.rect;
    imageRect.setLeft(imageRect.left() + 5);
    imageRect.setTop(imageRect.top() + 5);
    imageRect.setWidth(160);
    imageRect.setHeight(120);

    QImage image = index.data(AbstractVideoListModel::ThumbnailRole).value<QImage>();

    if (!image.isNull()) {
        painter->drawImage(imageRect, image);
    }
    else {
        painter->drawImage(imageRect.left() + 56, imageRect.top() + 36, QImage("/usr/share/icons/hicolor/48x48/hildon/general_video_file.png"));
    }

    painter->drawRect(imageRect);

    int duration = index.data(AbstractVideoListModel::DurationRole).toInt();

    QRect durationRect = imageRect;
    durationRect.setLeft(duration < 3600 ? durationRect.right() - 50 : durationRect.right() - 70);
    durationRect.setTop(durationRect.bottom() - 20);

    painter->setOpacity(0.5);
    painter->fillRect(durationRect, Qt::black);
    painter->setOpacity(1);
    painter->setPen(Qt::white);
    painter->drawText(durationRect, Qt::AlignCenter, Utils::durationFromSecs(duration));
    painter->restore();
}

QSize VideoSelectionDelegate::sizeHint(const QStyleOptionViewItem &option, const QModelIndex &index) const {
    Q_UNUSED(index)

    return QSize(option.rect.width(), 150);
}
