#include "networkaccessmanager.h"
#include "cookiejar.h"
#include <QNetworkReply>

CookieJar* NetworkAccessManager::cookieJar = 0;

NetworkAccessManager::NetworkAccessManager(QObject *parent) :
    QNetworkAccessManager(parent)
{
    if (!cookieJar) {
        cookieJar = new CookieJar;
    }

    this->setCookieJar(cookieJar);
    cookieJar->setParent(0);

    this->connect(this, SIGNAL(sslErrors(QNetworkReply*,QList<QSslError>)), this, SLOT(onSSLErrors(QNetworkReply*,QList<QSslError>)));
}

NetworkAccessManager::~NetworkAccessManager() {}

void NetworkAccessManager::onSSLErrors(QNetworkReply *reply, const QList<QSslError> &errors) {
    reply->ignoreSslErrors(errors);
}
