#include "vimeo.h"
#include "../../cutetubeapp/src/base/definitions.h"
#include "../../cutetubeapp/src/base/oauth.h"
#include <QNetworkAccessManager>
#include <QNetworkRequest>
#include <QNetworkReply>
#include <QDebug>
#if QT_VERSION >= 0x050000
#include <QUrlQuery>
#endif

using namespace QtOAuth;

Vimeo::Vimeo(QObject *parent) :
    QObject(parent),
    m_nam(0),
    m_clientId("b73846eb250c788a08bda2458be6ae9aebfda98e"),
    m_clientSecret("6d6a7f4b5f013efe183f12d6e09be31051eb5eed"),
    m_redirectUri("https://sites.google.com/site/marxodian/home/cutetube")
{
}

Vimeo::~Vimeo() {}

QNetworkReply* Vimeo::createReply(QString feed, int offset) {
    QUrl url(feed);
#if QT_VERSION >= 0x050000
    QUrlQuery query(url);

    if (offset) {
        query.addQueryItem("page", QString::number(offset));
    }

    url.setQuery(query);
#else
    if (offset) {
        url.addQueryItem("page", QString::number(offset));
    }
#endif
    qDebug() << url;

    QNetworkRequest request(url);
    request.setRawHeader("User-Agent", QString("cuteTube/%1 (Qt)").arg(VERSION_NUMBER).toUtf8());
    request.setRawHeader("Authorization", this->getOAuthHeader("GET", url, QMap<QString, QString>()));

    return this->networkAccessManager()->get(request);
}

QByteArray Vimeo::getOAuthHeader(const QString &method, const QUrl &url, QMap<QString, QString> params) {
    params.insert("oauth_consumer_key", m_clientId);
    params.insert("oauth_consumer_secret", m_clientSecret);

    if (this->userSignedIn()) {
        params.insert("oauth_token", this->accessToken());
        params.insert("oauth_token_secret", this->tokenSecret());
    }

    return OAuth::createOAuthHeader(method, url, params);
}

void Vimeo::setAccount(const QString &user, const QString &token, const QString &secret) {
    if (user != this->username()) {
        this->setUsername(user);
    }

    this->setAccessToken(token);
    this->setTokenSecret(secret);

    if ((user.isEmpty()) && (!token.isEmpty())) {
        emit newAccountSet();
    }
}
