#include "windowstack.h"
#include <QWidget>

WindowStack* WindowStack::self = 0;

WindowStack::WindowStack(QObject *parent) :
    QObject(parent)
{
    if (!self) {
        self = this;
    }
}

WindowStack*  WindowStack::instance() {
    return !self ? new WindowStack : self;
}

QWidget* WindowStack::currentWindow() const {
    return m_windowStack.isEmpty() ? 0 : m_windowStack.last();
}

QWidget* WindowStack::rootWindow() const {
    return m_windowStack.isEmpty() ? 0 : m_windowStack.first();
}

void WindowStack::addWindowToStack(QWidget *window) {
    m_windowStack.append(window);
    this->connect(window, SIGNAL(destroyed(QObject*)), this, SLOT(removeWindowFromStack(QObject*)));

}

void WindowStack::removeWindowFromStack(QObject *window) {
    m_windowStack.removeOne(qobject_cast<QWidget*>(window));
}

void WindowStack::unwindWindowStack() {
    for (int i = m_windowStack.size() - 1; i > 0; i--) {
        m_windowStack.at(i)->close();
    }
}
