#ifndef YOUTUBEPLAYLISTLISTTAB_H
#define YOUTUBEPLAYLISTLISTTAB_H

#include "abstracttab.h"
#include "../base/playlistitem.h"

class ListView;
class YouTubePlaylistListModel;
class QLabel;
class QGridLayout;
class QModelIndex;

class YouTubePlaylistListTab : public AbstractTab
{
    Q_OBJECT

public:
    explicit YouTubePlaylistListTab(QWidget *parent = 0);
    void setPlaylistFeed(const QUrl &feed);

private:
    void setLandscapeLayout();
    void setPortraitLayout();

private slots:
    void onLoadingChanged(bool loading);
    void onCountChanged(int count);
    void onItemClicked(const QModelIndex &index);
    void showPlaylist(QSharedPointer<PlaylistItem> playlist);

private:
    ListView *m_listView;
    YouTubePlaylistListModel *m_model;
    QLabel *m_noResultsLabel;
    QGridLayout *m_grid;
};

#endif // YOUTUBEPLAYLISTLISTTAB_H
