# -*- coding: utf-8 -*-

"""
Module implementing a series of context menus for use 
with cuteTube list widgets.
"""

from PyQt4.QtGui import *
from PyQt4.QtCore import *

class ContextMenuEventHandler(QObject):
    """
    Provides event handling for right click actions.
    """
    def __init__(self, parent):
        """
        Constructor
        """
        QObject.__init__(self, parent)

    def eventFilter(self, obj, event):
        if event.type() == QEvent.ContextMenu:
            mouseEvent = QMouseEvent(event)
            self.emit(SIGNAL("rightButtonClicked(QPoint)"), mouseEvent.globalPos())
            return True
        else:
            return QObject.eventFilter(obj, event)

class VideoListMenu(QMenu):
    """
    Context menu for video lists providing 
    options to play video, download video, 
    add to favourites and add to a playlist.
    """
    def __init__(self, parent, position):
        """
        Constructor
        """
        QMenu.__init__(self, parent)
        self.addAction("Play Video")
        self.addAction("Download Video")
        self.addAction("Add To Favourites")
        self.addAction("Add To Playlist")
        self.exec_(position)
