# -*- coding: utf-8 -*-

"""
Module implementing MyAccountWindow.
"""
from PyQt4.QtGui import *
from PyQt4.QtCore import *
try:
    from PyQt4.QtMaemo5 import QMaemo5InformationBox
except:
    pass
from Ui_myaccountwindow import Ui_MyAccountWindow
import cutetubewindows
import cutetubedialogs
import youtubeservice

class MyAccountWindow(QMainWindow, Ui_MyAccountWindow):
    """
    Window providing navigation around the user's account.
    """
    def __init__(self, parent = None):
        """
        Constructor
        """
        QMainWindow.__init__(self, parent)
        self.setupUi(self)
        self.setWindowTitle("My Channel")
        self.youtubeLabel = QLabel(self)
        self.youtubeLabel.setGeometry(QRect(10, 10, 150, 90))
        self.youtubeLabel.setPixmap(QPixmap(":/images/ui-images/youtube.png"))
        self.youtubeLabel.setScaledContents(True)
        try:
            self.setAttribute(Qt.WA_Maemo5StackedWindow) 
            self.setAttribute(Qt.WA_Maemo5AutoOrientation, True)
            self.orientationChanged()
            self.connect(QApplication.desktop(), SIGNAL("resized(int)"), self.orientationChanged) 
        except:
            pass
        for button in (self.uploadsButton, self.favouritesButton, self.playlistsButton, self.subscriptionsButton):
            button.setStyleSheet("border: 2px solid rgb(120, 120, 120); border-radius: 6px;")
        self.keyPressEvent = self.showSearchDialog
        self.searchDialogRaised = False
        taskQueueLength = len(youtubeservice.YouTubeVideoDownloader.taskQueue)
        if taskQueueLength > 0:
            self.actionDownloads.setVisible(True)
            self.actionDownloads.setText("Downloads (%s videos)" % unicode(taskQueueLength))
        if len(youtubeservice.YouTubeDataService.userDict) <= 1:
            self.actionSwitchAccount.setVisible(False)
        self.show()
        
    def showSearchDialog(self,  event):
        """
        Raises a SearchDialog when the user presses a key.
        """
        if event.key() not in (Qt.Key_Left, Qt.Key_Right, Qt.Key_Up, Qt.Key_Down, Qt.Key_Backspace, Qt.Key_Return, Qt.Key_Control, Qt.Key_Shift, Qt.Key_Space) and not self.searchDialogRaised:
            self.setSearchDialogRaised(True)
            searchDialog = cutetubedialogs.SearchDialog(self)
            searchDialog.lineEdit.insert(event.text())
            QTimer.singleShot(1000,  lambda isRaised = False: self.setSearchDialogRaised(isRaised))
        else:
            pass
            
    def setSearchDialogRaised(self,  isRaised):
        self.searchDialogRaised = isRaised


    def orientationChanged(self):
        """
        Re-orders the window's widgets.
        """
        screenGeometry = QApplication.desktop().screenGeometry()
        if screenGeometry.height() > screenGeometry.width():
            self.resize(480, 800)
            self.uploadsLabel.setGeometry(QRect(97, 278, 88, 26))
            self.uploadsButton.setGeometry(QRect(80, 150 , 120, 120))
            self.playlistsLabel.setGeometry(QRect(97, 527, 88, 26))
            self.playlistsButton.setGeometry(QRect(80, 400, 120, 120))
            self.subscriptionsLabel.setGeometry(QRect(268, 527, 147, 26))
            self.favouritesLabel.setGeometry(QRect(285, 278, 111, 26))
            self.subscriptionsButton.setGeometry(QRect(280, 400, 120, 120))
            self.favouritesButton.setGeometry(QRect(280, 150, 120, 120))
        else:
            self.resize(800, 480)
            self.uploadsLabel.setGeometry(QRect(82, 250, 88, 26))
            self.uploadsButton.setGeometry(QRect(66, 123, 120, 120))
            self.playlistsLabel.setGeometry(QRect(451, 250, 88, 26))
            self.playlistsButton.setGeometry(QRect(434, 123, 120, 120))
            self.subscriptionsLabel.setGeometry(QRect(603, 250, 147, 26))
            self.favouritesLabel.setGeometry(QRect(256, 250, 111, 26))
            self.subscriptionsButton.setGeometry(QRect(616, 123, 120, 120))
            self.favouritesButton.setGeometry(QRect(251, 123, 120, 120))

    def queueChanged(self, queueLength):
        """
        Makes actionGoToQueue visible if there are 
        videos in the user's playback queue.
        """
        if queueLength > 0:
            self.actionGoToQueue.setVisible(True)
            self.actionGoToQueue.setText("Queue (%s videos)" % unicode(queueLength))
        else:
            self.actionGoToQueue.setVisible(False)
        self.emit(SIGNAL("queueChanged(int)"), queueLength)
        
    def downloadsChanged(self,  taskQueueLength):
        """
        Makes actionDownloads visible if there are videos 
        in the user's download queue.
        """
        if taskQueueLength > 0:
            self.actionDownloads.setVisible(True)
            self.actionDownloads.setText("Downloads (%s videos)" % unicode(taskQueueLength))
        else:
            self.actionDownloads.setVisible(False)
        self.emit(SIGNAL("downloadsChanged(int)"), taskQueueLength)

    @pyqtSignature("")
    def on_actionGoToQueue_triggered(self):
        """
        Creates a PlayBackQueueWindow.
        """
        playbackQueueWindow = cutetubewindows.PlaybackQueueWindow(self)
        self.connect(playbackQueueWindow, SIGNAL("queueChanged(int)"), self.queueChanged)
        
    @pyqtSignature("")
    def on_actionDownloads_triggered(self):
        """
        Creates a DownloadsWindow
        """
        downloadsWindow = cutetubewindows.DownloadsWindow(self)
        self.connect(downloadsWindow, SIGNAL("queueChanged(int)"), self.queueChanged)
        self.connect(downloadsWindow, SIGNAL("downloadsChanged(int)"), self.downloadsChanged)
            
    @pyqtSignature("")
    def on_uploadsButton_clicked(self):
        """
        Creates a UploadsWindow
        """
        uploadsWindow = cutetubewindows.UploadsWindow(self)
        self.connect(uploadsWindow, SIGNAL("queueChanged(int)"), self.queueChanged)
        self.connect(uploadsWindow, SIGNAL("downloadsChanged(int)"), self.downloadsChanged)
    
    @pyqtSignature("")
    def on_favouritesButton_clicked(self):
        """
        Creates a FavouritesWindow.
        """
        favouritesWindow = cutetubewindows.FavouritesWindow(self)
        self.connect(favouritesWindow, SIGNAL("queueChanged(int)"), self.queueChanged)
        self.connect(favouritesWindow, SIGNAL("downloadsChanged(int)"), self.downloadsChanged)
    
    @pyqtSignature("")
    def on_playlistsButton_clicked(self):
        """
        Creates a PlaylistsWindow
        """
        playlistsWindow = cutetubewindows.PlaylistsWindow(self)
        self.connect(playlistsWindow, SIGNAL("queueChanged(int)"), self.queueChanged)
        self.connect(playlistsWindow, SIGNAL("downloadsChanged(int)"), self.downloadsChanged)
    
    @pyqtSignature("")
    def on_subscriptionsButton_clicked(self):
        """
        Raises a SubscriptionsWindow.
        """
        subscriptionsWindow = cutetubewindows.SubscriptionsWindow(self)
        self.connect(subscriptionsWindow, SIGNAL("queueChanged(int)"), self.queueChanged)
        self.connect(subscriptionsWindow, SIGNAL("downloadsChanged(int)"), self.downloadsChanged)
    
    @pyqtSignature("")
    def on_actionSwitchAccount_triggered(self):
        """
        Raises a SwitchAccountDialog
        """
        switchAccountDialog = cutetubedialogs.SwitchAccountDialog(self)
        


        
        
