/* qmpd.h
 *
 * Class for handling mpd.
 * (still not all mpd things are done in this class...)
 *
 */


#ifndef QMPD_H
#define QMPD_H

#include <QObject>
#include <QTimer>

#include <libmpd-1.0/libmpd/libmpd.h>


class Qmpd : public QObject
{
    Q_OBJECT

public:
    Qmpd(QString hostname, int iport, QString password = "");
    ~Qmpd();

    static Qmpd* static_this;
    bool isConnected() const;

    // We need the MpdObj for collection builder
    MpdObj* getMpdObj() const;

    // MPD callbacks
    void mpdErrorCallback(MpdObj *mi,int errorid, char *msg, void *userdata);
    void mpdStatusChangedEmitter(MpdObj *mi, ChangedStatusType what);

    // Removes items at positions
    void removeFromPlaylist(QList<int> positions);

    // Plays from specific position
    void playFromPos(int pos) const;

public slots:
    void onPlaypauseClick();
    void onStopClick();
    void onNextClick();
    void onPrevClick();
    void onSliderMoved(int value);
    void onSliderPress();
    void onSliderRelease();
    void onVolumeSliderMoved(int value);
    void onVolumeButton();
    void onTimerUpdate();
    void onClearPlaylist();
    void onUpdateDB();

signals:
    void mpdStatusChanged(MpdObj *mi, ChangedStatusType what);
    void mpdErrorOccured(MpdObj *mi);
    void updatePlaylistNow(MpdObj *mi);

private:
    MpdObj *obj_;
    QTimer *timer;
};

// MPD callbacks
void error_callback(MpdObj *mi,int errorid, char *msg, void *userdata);
void status_changed(MpdObj *mi, ChangedStatusType what);

#endif // QMPD_H
