#include "filebrowsertreemodel.h"
#include <QPixmap>

#include <QDebug>

FileBrowserTreeModel::FileBrowserTreeModel(QObject *parent) : QAbstractItemModel(parent)
{
    FileBrowserTreeItem* rootish = new FileBrowserTreeItem("");
    FileBrowserTreeItem* root = new FileBrowserTreeItem("/", rootish);
    rootItem_ = rootish;
    rootItem_->appendChild(root);
}

FileBrowserTreeModel::~FileBrowserTreeModel() {
    if ( rootItem_ )
        delete rootItem_;
}

QModelIndex FileBrowserTreeModel::index(int row, int column, const QModelIndex &parent) const {
    if (!hasIndex(row, column, parent))
        return QModelIndex();

    FileBrowserTreeItem *parentItem;

    if (!parent.isValid())
        parentItem = rootItem_;
    else
        parentItem = static_cast<FileBrowserTreeItem*>(parent.internalPointer());

    FileBrowserTreeItem *childItem = parentItem->child(row);
    if (childItem)
        return createIndex(row, column, childItem);
    else
        return QModelIndex();
}

QModelIndex FileBrowserTreeModel::parent(const QModelIndex &index) const {
    if (!index.isValid())
        return QModelIndex();

    FileBrowserTreeItem *childItem = static_cast<FileBrowserTreeItem*>(index.internalPointer());
    FileBrowserTreeItem *parentItem = childItem->parent();

    if (parentItem == rootItem_)
        return QModelIndex();

    return createIndex(parentItem->row(), 0, parentItem);
}

int FileBrowserTreeModel::rowCount(const QModelIndex &parent) const
{
    FileBrowserTreeItem *parentItem;
    if (parent.column() > 0)
        return 0;

    if (!parent.isValid())
        parentItem = rootItem_;
    else
        parentItem = static_cast<FileBrowserTreeItem*>(parent.internalPointer());

    return parentItem->childCount();
}

int FileBrowserTreeModel::columnCount(const QModelIndex &parent) const
{
    //     if (parent.isValid())
    //         return static_cast<TreeItem*>(parent.internalPointer())->columnCount();
    //     else
    //         return rootItem->columnCount();
    return 1;
}

QVariant FileBrowserTreeModel::data(const QModelIndex &index, int role) const
{
    if (!index.isValid())
        return QVariant();

    FileBrowserTreeItem *item = static_cast<FileBrowserTreeItem*>(index.internalPointer());
    if (role == Qt::UserRole) {
        return item->fullPath();
    }
    else if ( role == Qt::DisplayRole ) {
        return item->visiblePath();
    }
    else if ( role == Qt::DecorationRole ) {
        // Icon
        if ( item->isExpanded())
            return QPixmap(":/graphics/openfolder.png", "PNG");
        else
            return QPixmap(":/graphics/closedfolder.png", "PNG");
    }
    return QVariant();
}

Qt::ItemFlags FileBrowserTreeModel::flags(const QModelIndex &index) const
{
    if (!index.isValid())
        return 0;

    return Qt::ItemIsEnabled | Qt::ItemIsSelectable;
}

QVariant FileBrowserTreeModel::headerData(int section, Qt::Orientation orientation,
                                          int role) const
{
    if (orientation == Qt::Horizontal && role == Qt::DisplayRole)
        return tr("Path");

    return QVariant();
}

//
// Builds the model according to given tree
//
void FileBrowserTreeModel::setDirTree(MyTreeType &tree) {

    // Clear old entries if given an empty tree
    if ( tree.count() == 0 ) {
        if ( rootItem_ && rootItem_->childCount() ) { // <--- THIS CAUSES CRASH!??!?!?
            rootItem_->child(0)->killChildren(); // <--- this causes crash!!!
        }
    }

    FileBrowserTreeItem* parent = 0;
    QPair < QString, QStringList > path;
    foreach (path, tree) {
        if ( path.first == "/" ) {
            //FileBrowserTreeItem* newRoot = new FileBrowserTreeItem("/", rootItem_);
            //rootItem_->appendChild(newRoot);
            parent = rootItem_->child(0);
        }
        else {
            // Find right parent...
            parent = findItem(rootItem_->child(0), path.first);
        }
        if ( parent ) {
            foreach (QString childpath, path.second) {
                // If childpath already exists, no op
                if ( findItem(parent, childpath) ) {
                    continue;
                }
                FileBrowserTreeItem* child = new FileBrowserTreeItem(childpath, parent);
                parent->appendChild(child);
            }
        }
    }
}

//
// Finds child item with given fullpath (recursive)
//
FileBrowserTreeItem* FileBrowserTreeModel::findItem(FileBrowserTreeItem* parent, QString fullpath) const {
    if ( parent->childCount() == 0 ) {
        return 0;
    }
    for (int i = 0; i < parent->childCount() ; ++i) {
        if ( parent->child(i)->fullPath() == fullpath ) return parent->child(i);
        FileBrowserTreeItem* childresult = findItem(parent->child(i), fullpath);
        if ( childresult ) return childresult;
    }
    return 0;
}
