#include "connectdialog.h"
#include "ui_connectdialog.h"

ConnectDialog::ConnectDialog(QWidget *parent) :
    QDialog(parent),
    m_ui(new Ui::ConnectDialog)
{
    m_ui->setupUi(this);
}

ConnectDialog::~ConnectDialog()
{
    delete m_ui;
}

void ConnectDialog::changeEvent(QEvent *e)
{
    QDialog::changeEvent(e);
    switch (e->type()) {
    case QEvent::LanguageChange:
        m_ui->retranslateUi(this);
        break;
    default:
        break;
    }
}

QString ConnectDialog::getHost() {
    return m_ui->lineHost->text().trimmed();
}

QString ConnectDialog::getPasswd() {
    return m_ui->linePassword->text().trimmed();
}

int ConnectDialog::getPort() {
    bool bOK = false;
    int port = m_ui->spinPort->text().toInt(&bOK, 10);
    if ( bOK ) {
        return port;
    }
    return 0;
}

bool ConnectDialog::getAutoconnect() {
    return m_ui->checkBox->checkState() == Qt::Checked;
}
