#ifndef COLLECTIONBUILDER_H
#define COLLECTIONBUILDER_H

#include <QThread>
#include <QtGui>
#include <QTextCodec>

#include "qmpdsong.h"

#include <libmpd-1.0/libmpd/libmpd.h>

// Unlikely to appear on real artist or album names ;D
const QString NULL_ARTIST_OR_ALBUM_STRING = "makfefmweklfm23894239847298374iowerjtioermdnfgmwelkrjwoi88383838383838383838383";

class CollectionBuilder : public QThread
{
    Q_OBJECT

public:
    CollectionBuilder();
    void setMpd(MpdObj* mpd);
    void run();

    void setForceFromMPD(bool fromMpd);

    // Getters
    QStringList getArtists() const;
    QStringList getAlbums(QString artist = NULL_ARTIST_OR_ALBUM_STRING) const;
    QList<QmpdSong> getSongs(QString artist = NULL_ARTIST_OR_ALBUM_STRING, QString album = NULL_ARTIST_OR_ALBUM_STRING) const;

signals:
    void finished();

private:
    QStringList artists_;
    QStringList albums_;
    QMap<QString, QStringList> artistAlbums_;
    QList<QmpdSong> songs_;
    QMap< QPair<QString, QString>, QList<QmpdSong> > albumSongs_;
    MpdObj* mpd_;

    QTextCodec* codec_;
    bool buildFromFile_;
    bool forceBuildFromMPD_;

};

#endif // COLLECTIONBUILDER_H
