#include <QMessageBox>
#include "playlistitemdelegate.h"

PlaylistItemDelegate::PlaylistItemDelegate(QObject *parent) : QStyledItemDelegate(parent)
{
    npColor_.setRgb(160,30,30);
}

void PlaylistItemDelegate::paint(QPainter *painter, const QStyleOptionViewItem &option, const QModelIndex &index) const {
    if ( index.data(Qt::UserRole + 1).toBool() ) {
        // Row of the now playing song
        painter->save();
#if defined (Q_WS_MAEMO_5) || defined (Q_WS_HILDON)
        QFont tmpFont("Arial", 8, QFont::Bold, true);
#else
        QFont tmpFont("Arial", 10, QFont::Bold, true);
#endif
        painter->setFont(tmpFont);
        painter->setPen(QColor(Qt::white));

        // Background color
        QColor bgcolor = npColor_;
        if(option.state & QStyle::State_Selected){
            bgcolor = option.palette.color(QPalette::Highlight);
        }
        painter->fillRect(option.rect, bgcolor);

        QString tmpStr = index.data(Qt::DisplayRole).toString();
        QRect tmpRect = option.rect.adjusted(2, 2, -2, -2);

        // Let's put "..." in the right spot if whole text doesn't fit
        QFontMetrics fm(tmpFont);
        int wdots = fm.width("...");
        int w = tmpRect.width();
        int wmax = fm.averageCharWidth();
        int chars = (w - wdots) / wmax;
        if ( chars == 0 ) {
            tmpStr = "...";
        }
        else if (chars < tmpStr.length()) {
            tmpStr = tmpStr.remove(chars-1, 3000) + "...";
        }

        painter->drawText(tmpRect.left(), tmpRect.top(), tmpRect.width(), tmpRect.height(),
                          Qt::AlignVCenter|Qt::AlignLeft, //|Qt::TextWordWrap,
                          tmpStr, 0);

        painter->restore();
    }
    else {
        QStyledItemDelegate::paint(painter, option, index);
    }
}

void PlaylistItemDelegate::setNpColor(QColor col) {
    if ( col != Qt::transparent ) {
        npColor_ = col;
    }
}

QColor PlaylistItemDelegate::getNpColor() const {
    return npColor_;
}
