#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <QtGui>
#include <QTextCodec>

#ifdef Q_WS_MAEMO_5
#include <QtMaemo5>
//#include <QtDBus>
//#include <mce/mode-names.h>
//#include <mce/dbus-names.h>
#endif

#include "songmodel.h"
#include "coverfetcher.h"
#include "collectionartistmodel.h"
#include "collectionalbummodel.h"
#include "filebrowsertreemodel.h"
#include "qmpd.h"
#include "collectionbuilder.h"
#include "songsortfiltermodel.h"
#include "playlistitemdelegate.h"
#include "settingsdialog.h"
#include "scrobbler.h"


namespace Ui
{
    class MainWindow;
}

class MainWindow : public QMainWindow
{
    Q_OBJECT

public:
    MainWindow(QWidget *parent = 0);
    ~MainWindow();

    bool setQmpd(Qmpd *qm);

    // Shows message either in statusbar or in maemo style
    void myShowMessage(QString message);

//#ifdef Q_WS_MAEMO_5
//    // Orientation change
//    void setPortrait();
//    void setLandscape();
//#endif


protected:
    // Close to tray
    void closeEvent(QCloseEvent *event);

//#ifdef Q_WS_MAEMO_5
//    bool event(QEvent *ev);
//#endif

    /* * * * * * * * * * * * * * * * * * * * * * */
    /* * * * * * * S L O T S * * * * * * * * * * */
    /* * * * * * * * * * * * * * * * * * * * * * */
public slots:
    void onMpdError(MpdObj *mi);
    void onMpdStatusChange(MpdObj *mi, ChangedStatusType what);  
    void onDisconnect();
    void onConnectLocalhost();
    void onConnectOther();
    void onSettings();
    void onEnableScrobbling(bool checked);
    void onCoverFetched(bool success);
    void onCoverShowFullSize();
    void onToggleFullscreen();
    void onEnter();
    void onSpace();
#if !defined (Q_WS_MAEMO_5) && !defined (Q_WS_HILDON)
    void iconActivated(QSystemTrayIcon::ActivationReason reason);
#endif
//#ifdef Q_WS_MAEMO_5
//    void orientationChanged(const QString &newOrientation);
//#endif

    /* * * * * * * PLAYLIST SLOTS * * * * * * */
    void onDeleteSelectedFromPlaylist();
    void updatePlaylist(MpdObj *mi);
    void onPlaylistDoubleClick(const QModelIndex & index);
    void onCutSelected();
    void onPasteSongs();

    /* * * * * * COLLECTION SLOTS * * * * * */
    void onCollectionBuilt();
    void onCArtistClick(QModelIndex index);
    void onCAlbumClick(QModelIndex index);
    void onAddArtist();
    void onAddAlbum();
    void onAddTrack();

    /* * * * * * FILE BROWSER SLOTS * * * * */
    void onFBDirClicked(QModelIndex index);
    void onFBDirCollapsed(QModelIndex index);
    void onUpdateDir();
    void onAddDir();
    void onAddTrackFB();

    /* * * * * * * * * * * * * * * * * * * * * * */
    /* * * * * * E N D   O F   S L O T S * * * * */
    /* * * * * * * * * * * * * * * * * * * * * * */



private:

    /* * * * * * * * * * * * * * * * * * * * * * */
    /* * * * * * * * GENERAL STUFF * * * * * * * */
    /* * * * * * * * * * * * * * * * * * * * * * */

    // Ui...
    Ui::MainWindow *ui;

    // Stuff for System tray icon
#if !defined (Q_WS_MAEMO_5) && !defined (Q_WS_HILDON)
    QAction *trayQuitAction_;
    QAction *trayPlayAction_;
    QAction *trayStopAction_;
    QAction *trayNextAction_;
    QAction *trayPrevAction_;
    QMenu *trayIconMenu_;
    QSystemTrayIcon* trayIcon_;
    void createTrayIcon();
    void enableTrayControlActions(bool enabled);
#endif

    // General actions
    QAction *cutAction_;
    QAction *pasteAction_;
    QAction *deleteAction_;
    QAction *fullscreenAction_;
    QAction *enterAction_;
    QAction *spaceAction_;
    QAction *updateDirAction_;

    void createActions();

    void setupTables();

    bool connectMPD(QString host, int port, QString passwd = "");
    bool autoConnectMPD();
    // MPD/MPC related stuff
    Qmpd *qmpd_;
    SongModel *playlistModel_;

    QmpdSong *currentSong_;
    bool scrobbled_; // have we scrobbled current song

    // Cover fetcher
    CoverFetcher coverFetcher_;
    QPixmap currentCover_; // DOES NOTHING FOR NOW

    // Context menu for album art
    QAction* coverShowFull_;
    QTextCodec* codec_;

    // Enables/disables some widgets etc.
    void activateUi(bool activated);

    // Audioscrobbler
    Scrobbler scrobbler_;

    /* * * * * * * * * * * * * * * * * * * * * */
    /* * * * * * * *  SETTINGS * * * * * * * * */
    /* * * * * * * * * * * * * * * * * * * * * */

    // Save/restore application state
    void saveAppState() const;
    void restoreAppState();

    // Load/save app settings
    void loadSettings();
    void saveSettings() const;

#if !defined (Q_WS_MAEMO_5) && !defined (Q_WS_HILDON)
    bool trayNoteOnTrackChange_;
#endif
    bool delAlbumArtOnExit_;
    QColor npColor_;
    QString lastFmUser_;
    QString lastFmPasswdHash_;

    /* * * * * * * * * * * * * * * * * * * * * */
    /* * * * * * *  PLAYLIST   * * * * * * * * */
    /* * * * * * * * * * * * * * * * * * * * * */

    QList<QString> myClipboard_; // song paths

    // Playlist item delegate to hilight now playing song
    PlaylistItemDelegate *plDelegate_;
    void onSongChange(mpd_Song* song);


    /* * * * * * * * * * * * * * * * * * * * * */
    /* * * * * * *  COLLECTION * * * * * * * * */
    /* * * * * * * * * * * * * * * * * * * * * */

    void buildCollectionNow();

    // Collection builder
    CollectionBuilder collectionBuilder_;

    // Collection models
    CollectionArtistModel CArtistModel_;
    CollectionAlbumModel CAlbumModel_;

    // Context menus for collection
    void buildCollectionMenus();
    QAction* CArMAdd_;
    QAction* CAlMAdd_;
    QAction* CTMAdd_;


    /* * * * * * * * * * * * * * * * * * * * * */
    /* * * * * * * FILEBROWSER * * * * * * * * */
    /* * * * * * * * * * * * * * * * * * * * * */

    void initializeFileBrowser();
    bool buildFBTreePath(QString path = "/");
    void buildFileBrowserMenus();
    SongSortFilterModel* fileModel_;
    FileBrowserTreeModel* FBModel_;
    MyTreeType FBDirTree_;
    QMap<QString, bool> builtPaths_;
    QAction* FBDMAdd_;
    QAction* FBDMUpdate_;
    QAction* FBFMAdd_;

};

#endif // MAINWINDOW_H
