#include <QtGui>
#include "filebrowsertreeitem.h"

FileBrowserTreeItem::FileBrowserTreeItem(QString fullpath, FileBrowserTreeItem* parent) :
        parent_(parent), fullPathname_(fullpath), expanded_(false)
{
    // Parse visible name (the last path or filename
    if ( parent && fullpath != "/" ) {
        QString parentPath = parent->fullPath();
        visiblePathname_ = fullpath.remove(parentPath);
        if ( visiblePathname_.at(0) == '/' ) visiblePathname_.remove(0,1);
    }
    else {
        visiblePathname_ = fullpath;
    }

}

FileBrowserTreeItem::~FileBrowserTreeItem() {
    qDeleteAll(children_);
}

bool FileBrowserTreeItem::isExpanded() const {
    return expanded_;
}

void FileBrowserTreeItem::setExpanded(bool exp) {
    expanded_ = exp;
}

void FileBrowserTreeItem::killChildren() {
    if (children_.count()) {
        children_.clear();
    }
}

void FileBrowserTreeItem::appendChild(FileBrowserTreeItem* child) {
    children_.append(child);
}

int FileBrowserTreeItem::row() const {
    if ( parent_ )
    {
        return parent_->children_.indexOf(const_cast<FileBrowserTreeItem*>(this));
    }
    return 0; // Parent of all
}

int FileBrowserTreeItem::childCount() const {
    return children_.count();
}

FileBrowserTreeItem* FileBrowserTreeItem::parent() const {
    return parent_;
}

QString FileBrowserTreeItem::visiblePath() const {
    return visiblePathname_;
}

QString FileBrowserTreeItem::fullPath() const {
    return fullPathname_;
}

FileBrowserTreeItem* FileBrowserTreeItem::child(int row) {
    return children_.value(row);
}
