#ifndef COVERFETCHER_H
#define COVERFETCHER_H

#include <QThread>
#include <QDomNode>
#include <QImage>
#include <QMutex>
#include <QStringList>
#include <QUrl>

class CoverFetcher : public QThread
{
    Q_OBJECT

public:
    CoverFetcher();
    void run();

    void setAlbumArtist(QString artist, QString album);

signals:
    void finished(bool success);

private:
    // Actual fetching
    void fetch();
    void download(const QUrl &url, const QString &filename);

    bool success_;
    QString artist_;
    QString album_;
};

#endif // COVERFETCHER_H
