#include <QColorDialog>
#include <QDebug>
#include <cstdio>

#include "settingsdialog.h"
#include "ui_settingsdialog.h"
#include "md5.h"

SettingsDialog::SettingsDialog(QWidget *parent) :
    QDialog(parent),
    ui(new Ui::SettingsDialog)
{
    ui->setupUi(this);
    connect(ui->btnColor, SIGNAL(clicked()), this, SLOT(onBtnColor()));

#if defined (Q_WS_MAEMO_5) || defined (Q_WS_HILDON)
    ui->checkTraynote->setVisible(false);
#endif

}

SettingsDialog::~SettingsDialog()
{
    delete ui;
}

void SettingsDialog::changeEvent(QEvent *e)
{
    QDialog::changeEvent(e);
    switch (e->type()) {
    case QEvent::LanguageChange:
        ui->retranslateUi(this);
        break;
    default:
        break;
    }
}

void SettingsDialog::setInitialValues(QString lfmuser, bool delart, QColor npcol) {
    lastFmUser_ = lfmuser;
    ui->lineLFMUser->setText(lfmuser);

    delArt_ = delart;
    ui->checkDelArt->setChecked(delart);

    npCol_ = npcol;

    // Show the current color
    QPixmap colmap(16,16);
    colmap.fill(npCol_);
    QIcon icon(colmap);
    ui->btnColor->setIcon(icon);
}
// Overloaded version for versions with tray notification
void SettingsDialog::setInitialValues(QString lfmuser, bool delart, QColor npcol, bool traynote) {
    trayNote_ = traynote;
    ui->checkTraynote->setChecked(traynote);
    setInitialValues(lfmuser, delart, npcol);
}

QString SettingsDialog::getLFMUser() {
    lastFmUser_ = ui->lineLFMUser->text();
    return lastFmUser_;
}

QString SettingsDialog::getLFMHash() {
    if ( ui->lineLFMPasswd->text().length() ) {
        lastFmHash_ = calculateHash(ui->lineLFMPasswd->text());
    }
    else {
        lastFmHash_ = "";
    }
    return lastFmHash_;
}

bool SettingsDialog::getDelArt() {
    delArt_ = ui->checkDelArt->isChecked();
    return delArt_;
}

bool SettingsDialog::getTrayNote() {
    trayNote_ = ui->checkTraynote->isChecked();
    return trayNote_;
}

QColor SettingsDialog::getNpCol() {
    return npCol_;
}

void SettingsDialog::onBtnColor() {
    QColor tmp = QColorDialog::getColor(npCol_, this);
    if ( tmp.isValid() )
        npCol_ = tmp;

    // Color icon
    QPixmap colmap(16,16);
    colmap.fill(npCol_);
    QIcon icon(colmap);
    ui->btnColor->setIcon(icon);
}

// TODO: Move this to misc.cpp or something so it can be used also in scrobbler
QString SettingsDialog::calculateHash(QString str) {
    if ( str.length() == 0 ) {
        return "";
    }
    const char *in = str.toLatin1();

    md5_state_t md5state;
    unsigned char md5result[16];
    char *tmp;
    int i;
    char a[3];

    md5_init (&md5state);
    md5_append (&md5state, (unsigned const char *) in, (int) strlen (in));
    md5_finish (&md5state, md5result);

    tmp = (char *) calloc (34, 1);

    for (i = 0;i < 0x10; i++)
    {
        snprintf(a, 3, "%02x", md5result[i]);
        tmp[(i<<1)] = a[0];
        tmp[(i<<1)+1] = a[1];
    }

    QString res(tmp);
    free (tmp);
//    qDebug() << "MD5 response: " << res;
    return res;
}
