#include "songmodel.h"

SongModel::SongModel() : title_(0), artist_(1), album_(2), track_(3), date_(4), duration_(5), file_(6)
{
}

SongModel::~SongModel()
{
    foreach (QmpdSong *s, songList) {
        delete s;
    }
}

//
// Row count
//
int SongModel::rowCount ( const QModelIndex & parent ) const
{
    return songList.size();
}

//
// Column count
//
int SongModel::columnCount ( const QModelIndex & parent  ) const
{
    return 7;
}

//
// Data
//
QVariant SongModel::data ( const QModelIndex & index, int role ) const
{
    QVariant result = QVariant();
    if (role == Qt::DisplayRole)
    {
        if (index.column() == title_) {
            if ( songList[index.row()]->title_ == "") {
                QFileInfo finfo(songList[index.row()]->file_);
                result = QVariant(finfo.baseName());
            }
            else
                result = QVariant(songList[index.row()]->title_);
        }
        else if (index.column() == artist_) {
            result = QVariant(songList[index.row()]->artist_);
        }
        else if (index.column() == album_) {
            result = QVariant(songList[index.row()]->album_);
        }
        else if (index.column() == track_) {
            result = QVariant(songList[index.row()]->track_);
        }
        else if (index.column() == date_) {
            result = QVariant(songList[index.row()]->date_);
        }
        else if (index.column() == duration_) {
            result = QVariant(songList[index.row()]->sTime_);
        }
        else if (index.column() == file_) {
            QFileInfo finfo(songList[index.row()]->file_);
            result = QVariant(finfo.fileName());
        }
//        if ( songList[index.row()]->nowPlaying_ ) {
//            QString tmp = "<b>" + result.toString() + "</b>";
//            result = QVariant(tmp);
//        }

    }
    else if (role == Qt::UserRole) {
        result = QVariant(songList[index.row()]->file_);
    }
    else if (role == Qt::UserRole + 1) {
        result = QVariant(songList[index.row()]->nowPlaying_);
    }
    return result;
}

//
// Add item
//
void SongModel::addItem(QmpdSong *song)
{
    // Add new row to end of the table
    beginInsertRows(QModelIndex(),songList.count(),songList.count());
    songList.append(song);
    endInsertRows();
}

//
// Header data
//
QVariant SongModel::headerData ( int section, Qt::Orientation orientation, int role ) const
{
    QVariant  result;
    if(orientation == Qt::Horizontal && role == Qt::DisplayRole)
    {
        if (section == title_) {
            result = QVariant(tr("Title"));
        }
        else if (section == artist_) {
            result = QVariant(tr("Artist"));
        }
        else if (section == album_) {
            result = QVariant(tr("Album"));
        }
        else if (section == track_) {
            result = QVariant(tr("Track"));
        }
        else if (section == date_) {
            result = QVariant(tr("Date"));
        }
        else if (section == duration_) {
            result = QVariant(tr("Duration"));
        }
        else if (section == file_) {
            result = QVariant(tr("File"));
        }
    }
    return result;
}

//
// Remove item
//
void SongModel::removeItem(int ind)
{
    beginRemoveRows(QModelIndex(),ind,ind);
    delete songList.at(ind);
    songList.removeAt(ind);
    endRemoveRows();
}

//
// To find out row number of specific song
//
int SongModel::onWhichRow(int songId) {
    for (int i = 0 ; i < songList.count() ; ++i) {
        if ( songList.at(i)->id_ == songId ) {
            return i;
        }
    }
    return -1; // Not found
}

//
// Sets now playing song for hilightning
//
void SongModel::setNowPlaying(int rowNumber) {
    foreach (QmpdSong *tmp, songList) {
        tmp->nowPlaying_ = false;
    }
    songList.at(rowNumber)->nowPlaying_ = true;
}
