#ifndef SCROBBLER_H
#define SCROBBLER_H

#include <QThread>
#include <QQueue>
#include <QString>

#include "qmpdsong.h"

class Scrobbler : public QThread
{
public:
    Scrobbler();

    void run();

    void setUser(QString user, QString md5sum);
    void enqueueSong(QmpdSong song);

    void handshake();
    void submit();

private:
    enum State { NOTHING, HANDSHAKING, READY, SUBMITTING, BADAUTH };
    enum HandshakeResult { COMMAND, CHALLENGE, SUBMIT };
    enum SubmitResult { OK, NOP, FAILED, HANDSHAKE };

    QQueue<QmpdSong> songQueue_;
    QString lfmUser_;
    QString lfmMd5_;

    QString submitUrl_;
    QString submitHash_;
    int interval_;


    State state_;

    // A few constants
    static const QString CLIENT_ID;
    static const QString CLIENT_VERSION;
    static const QString ASCROBBLER_HOST;
    static const int MAX_VAR_SIZE = 8192;
    static const int MAX_TIMESTAMP_SIZE = 64;
    static const int MAX_SUBMIT_COUNT = 10;
};

#endif // SCROBBLER_H
