#include "scrobbler.h"

#include <QUrl>
#include <QStringList>
#include <QDebug>
#include <QtNetwork>

const QString Scrobbler::CLIENT_ID = QString("mdc"); // ???
const QString Scrobbler::CLIENT_VERSION = QString("VERSION"); // ???
const QString Scrobbler::ASCROBBLER_HOST = QString("http://post.audioscrobbler.com/");

Scrobbler::Scrobbler() : state_(NOTHING)
{
}

//
// Set username and md5 hash
//
void Scrobbler::setUser(QString user, QString md5sum) {
    lfmUser_ = user;
    lfmMd5_ = md5sum;
}

//
// Adds a song to the queue
//
void Scrobbler::enqueueSong(QmpdSong song) {
    songQueue_.enqueue(song);
}

//
// Handshakes with the audioscrobbler server
//
void Scrobbler::handshake() {
    state_ = HANDSHAKING;

    QUrl url(ASCROBBLER_HOST);
    url.addQueryItem("hs", "true");
    url.addQueryItem("p", "1.1");
    url.addQueryItem("c", CLIENT_ID);
    url.addQueryItem("v", CLIENT_VERSION);
    url.addQueryItem("u", lfmUser_);

//    qDebug() << url;

    QNetworkAccessManager manager;
    QEventLoop loop;
    QNetworkReply *reply = manager.get(QNetworkRequest(url));
    QObject::connect(reply, SIGNAL(finished()), &loop, SLOT(quit()));
    loop.exec();

    if ( reply->error() ) {
        // Connection timed out or some other error
        state_ = NOTHING;
        // increase interval
        return;
    }

    QString sReply = reply->readAll();
    delete reply;
    QStringList slReply = sReply.split('\n');

    if ( slReply.at(0).trimmed() == "UPTODATE" ) {
        // All fine
        QString hash = slReply.at(1).trimmed();
        // need to md5(lfmMD5_ + hash)
        submitUrl_ = slReply.at(2).trimmed();
        QString tmp = slReply.at(3).trimmed();
        QString sInterval = tmp.at(tmp.length()-1);

        bool bOk = false;
        interval_ = sInterval.toInt(&bOk);

        if ( !bOk ) {
            // Something went wrong
            state_ = NOTHING;
            return;
        }

    }
//    else if ( slReply.at(0).trimmed() == "UPDATE" ) {
//
//    }
//    else if ( slReply.at(0).trimmed() == "FAILED" ) {
//
//    }
//    else if ( slReply.at(0).trimmed() == "BADUSER" ) {
//
//    }
//    else if ( slReply.at(0).trimmed() == "BADAUTH" ) {
//
//    }

    state_ = READY;

}

//
// Submits song(s)
//
void Scrobbler::submit() {
    if ( !songQueue_.size() ) {
        return;
    }
    state_ = SUBMITTING;

}


//
// Run Forrest run
//
void Scrobbler::run() {
    // Testing
    handshake();
}

