#ifndef UNITSETTINGS_H
#define UNITSETTINGS_H

#include <QMainWindow>
#include <QSettings>
#include "help.h"

namespace Ui {
    class UnitSettings;
}

class UnitSettings : public QMainWindow {
    Q_OBJECT
public:
    UnitSettings(QWidget *parent = 0);
    ~UnitSettings();

protected:
    void changeEvent(QEvent *e);

private:
    Ui::UnitSettings *ui;
    Help *helpWindow;
    QSettings mvSettings;
    QString mvUnit1;
    QString mvUnit2;
    QString mvUnitName1;
    QString mvUnitName2;
    QString mvUnitSymbol1;
    QString mvUnitSymbol2;
    QString mvUnitType;
    QString mvSelectedType;
    QStringList mvUnits;
    QStringList mvPresets;    

    void initialSettings();
    void unitKey(int whichUnit);
    void updateButtons();
    void updatePreset();
    void updatePresetList();

private slots:
    void on_actionHelp_triggered();
    void on_pushButton_Apply_clicked();
    void on_pushButton_Delete_clicked();
    void on_pushButton_Preset_clicked();
    void on_pushButton_Unit2_clicked();
    void on_pushButton_Unit1_clicked();
    void updateList(QString unitType);

};

#endif // UNITSETTINGS_H
