#include "mainwindow.h"
#include "ui_mainwindow.h"

MainWindow::MainWindow(QWidget *parent) :
    QMainWindow(parent),
    ui(new Ui::MainWindow)
{
    ui->setupUi(this);
    ui->lineEdit->setValidator(new QDoubleValidator(0, 0, 2, this));

    initialSettings();
    if (mvSettings.value("AutoUpdate").toBool()) {
        updateCurrency();
    }    
}

MainWindow::~MainWindow()
{
    delete ui;
}

void MainWindow::changeEvent(QEvent *e)
{
    QMainWindow::changeEvent(e);
    switch (e->type()) {
    case QEvent::LanguageChange:
        ui->retranslateUi(this);
        break;
    default:
        break;
    }
}

void MainWindow::initialSettings()
{  
    if (mvSettings.value("Version").toInt() < 804) {
        mvSettings.remove("");
        mvSettings.setValue("Restore", true);
        mvSettings.setValue("Version", 804);
    }

    if (!mvSettings.contains("AutoUpdate")) {
        mvSettings.setValue("AutoUpdate", true);
    }

    if (mvSettings.value("Restore").toBool()) {
        ui->lineEdit->clear();
        ui->label->clear();
        ui->labelSmall->clear();

        mvSettings.setValue("Restore", false);
        mvSettings.setValue("Currency", true);
        mvSettings.setValue("Currency1", "EUR");
        mvSettings.setValue("Currency2", "USD");
        mvSettings.setValue("TaxRate", 20);
        mvSettings.setValue("TipRate", 10);

        mvSettings.beginGroup("Currency");
        mvSettings.setValue("EUR", 1);
        mvSettings.setValue("AED", 0);
        mvSettings.setValue("ANG", 0);
        mvSettings.setValue("AOA", 0);
        mvSettings.setValue("ARS", 0);
        mvSettings.setValue("AUD", 1.5547);
        mvSettings.setValue("BBD", 0);
        mvSettings.setValue("BGN", 1.9558);
        mvSettings.setValue("BHD", 0);
        mvSettings.setValue("BMD", 0);
        mvSettings.setValue("BND", 0);
        mvSettings.setValue("BRL", 2.5438);
        mvSettings.setValue("BSD", 0);
        mvSettings.setValue("CAD", 1.4752);
        mvSettings.setValue("CHF", 1.4756);
        mvSettings.setValue("CLP", 0);
        mvSettings.setValue("CNY", 9.8130);
        mvSettings.setValue("CVE", 0);
        mvSettings.setValue("CZK", 25.947);
        mvSettings.setValue("DKK", 7.4420);
        mvSettings.setValue("EEK", 15.6466);
        mvSettings.setValue("DOP", 0);
        mvSettings.setValue("EGP", 0);
        mvSettings.setValue("FJD", 0);
        mvSettings.setValue("GBP", 0.88105);
        mvSettings.setValue("GYD", 0);
        mvSettings.setValue("HKD", 11.1536);
        mvSettings.setValue("HRK", 7.2890);
        mvSettings.setValue("HUF", 266.80);
        mvSettings.setValue("IDR", 13245.61);
        mvSettings.setValue("ILS", 0);
        mvSettings.setValue("INR", 65.7000);
        mvSettings.setValue("IRR", 0);
        mvSettings.setValue("JMD", 0);
        mvSettings.setValue("JPY", 130.76);
        mvSettings.setValue("KES", 0);
        mvSettings.setValue("KHR", 0);
        mvSettings.setValue("KRW", 1614.29);
        mvSettings.setValue("KWD", 0);
        mvSettings.setValue("KYD", 0);
        mvSettings.setValue("KZT", 0);
        mvSettings.setValue("LTL", 3.4528);
        mvSettings.setValue("LVL", 0.7085);
        mvSettings.setValue("MAD", 0);
        mvSettings.setValue("MOP", 0);
        mvSettings.setValue("MXN", 18.2790);
        mvSettings.setValue("MYR", 4.8002);
        mvSettings.setValue("MZN", 0);
        mvSettings.setValue("NOK", 8.1430);
        mvSettings.setValue("NZD", 1.9497);
        mvSettings.setValue("OMR", 0);
        mvSettings.setValue("PAB", 0);
        mvSettings.setValue("PEN", 0);
        mvSettings.setValue("PHP", 65.867);
        mvSettings.setValue("PKR", 0);
        mvSettings.setValue("PLN", 4.0399);
        mvSettings.setValue("QAR", 0);
        mvSettings.setValue("RON", 4.1043);
        mvSettings.setValue("RSD", 0);
        mvSettings.setValue("RUB", 42.5015);
        mvSettings.setValue("SAR", 0);
        mvSettings.setValue("SEK", 10.1430);
        mvSettings.setValue("SGD", 1.9984);
        mvSettings.setValue("STD", 0);
        mvSettings.setValue("SYP", 0);
        mvSettings.setValue("THB", 47.244);
        mvSettings.setValue("TRY", 2.0900);
        mvSettings.setValue("TTD", 0);
        mvSettings.setValue("TWD", 0);
        mvSettings.setValue("UAH", 0);
        mvSettings.setValue("USD", 1.4374);
        mvSettings.setValue("VEF", 0);
        mvSettings.setValue("VND", 0);
        mvSettings.setValue("XAF", 0);
        mvSettings.setValue("XCD", 0);
        mvSettings.setValue("XOF", 0);
        mvSettings.setValue("YER", 0);
        mvSettings.setValue("ZAR", 10.6588);
        mvSettings.endGroup();

        mvSettings.beginGroup("CurrencyName");
        mvSettings.setValue("EUR", "Euro");
        mvSettings.setValue("AED", "United Arab Emirates Dirham");
        mvSettings.setValue("ANG", "Netherlands Antilles Guilder");
        mvSettings.setValue("AOA", "Angola Kwanza");
        mvSettings.setValue("ARS", "Argentina Peso");
        mvSettings.setValue("AUD", "Australia Dollar");
        mvSettings.setValue("BBD", "Barbados Dollar");
        mvSettings.setValue("BGN", "Bulgaria Lev");
        mvSettings.setValue("BHD", "Bahrain Dinar");
        mvSettings.setValue("BMD", "Bermuda Dollar");
        mvSettings.setValue("BND", "Brunei Dollar");
        mvSettings.setValue("BRL", "Brazil Real");
        mvSettings.setValue("BSD", "Bahamas Dollar");
        mvSettings.setValue("CAD", "Canada Dollar");
        mvSettings.setValue("CHF", "Swiss Franc");
        mvSettings.setValue("CLP", "Chile Peso");
        mvSettings.setValue("CNY", "China Yuan");
        mvSettings.setValue("CVE", "Cape Verde Escudo");
        mvSettings.setValue("CZK", "Czech Republic Koruna");
        mvSettings.setValue("DKK", "Denmark Krone");
        mvSettings.setValue("DOP", "Dominican Republic Peso");
        mvSettings.setValue("EEK", "Estonia Kroon");
        mvSettings.setValue("EGP", "Egypt Pound");
        mvSettings.setValue("FJD", "Fiji Dollar");
        mvSettings.setValue("GBP", "United Kingdom Pound");
        mvSettings.setValue("GYD", "Guyana Dollar");
        mvSettings.setValue("HKD", "Hong Kong dollar");
        mvSettings.setValue("HRK", "Croatia Kuna");
        mvSettings.setValue("HUF", "Hungaria Forint");
        mvSettings.setValue("IDR", "Indonesia Rupiah");
        mvSettings.setValue("ILS", "Israel New Shekel");
        mvSettings.setValue("INR", "India Rupee");
        mvSettings.setValue("IRR", "Iran Rial");
        mvSettings.setValue("JMD", "Jamaica Dollar");
        mvSettings.setValue("JPY", "Japan Yen");
        mvSettings.setValue("KES", "Kenya Schilling");
        mvSettings.setValue("KHR", "Cambodia Riel");
        mvSettings.setValue("KRW", "South Korea Won");
        mvSettings.setValue("KWD", "Kuwait Dinar");
        mvSettings.setValue("KYD", "Cayman Islands Dollar");
        mvSettings.setValue("KZT", "Kazakhstan Tenge");
        mvSettings.setValue("LTL", "Lithuania Litas");
        mvSettings.setValue("LVL", "Latvia Lats");
        mvSettings.setValue("MAD", "Morocco Dirham");
        mvSettings.setValue("MOP", "Macau Pataca");
        mvSettings.setValue("MXN", "Mexico Peso");
        mvSettings.setValue("MYR", "Malaysia Ringgit");
        mvSettings.setValue("MZN", "Mozambican Metical");
        mvSettings.setValue("NOK", "Norway Krone");
        mvSettings.setValue("NZD", "New Zealand Dollar");
        mvSettings.setValue("OMR", "Oman Rial");
        mvSettings.setValue("PAB", "Panama Balboa");
        mvSettings.setValue("PEN", "Peru Neuevo Sol");
        mvSettings.setValue("PHP", "Philippine Peso");
        mvSettings.setValue("PKR", "Pakistan Rupee");
        mvSettings.setValue("PLN", "Poland Zloty");
        mvSettings.setValue("QAR", "Qatar Rial");
        mvSettings.setValue("RON", "Romania Leu");
        mvSettings.setValue("RSD", "Serbia Dinar");
        mvSettings.setValue("RUB", "Russia Rouble");
        mvSettings.setValue("SAR", "Saudi Arabia Riyal");
        mvSettings.setValue("SEK", "Sweden Krona");
        mvSettings.setValue("SGD", "Singapore Dollar");
        mvSettings.setValue("STD", "Sao Tome and Principe Dobra");
        mvSettings.setValue("SYP", "Syrian Pound");
        mvSettings.setValue("THB", "Thailand Baht");
        mvSettings.setValue("TRY", "Turkey Lira");
        mvSettings.setValue("TTD", "Trinidad and Tobago Dollar");
        mvSettings.setValue("TWD", "Taiwan Dollar");
        mvSettings.setValue("UAH", "Ukraine Hryvnia");
        mvSettings.setValue("USD", "United States Dollar");
        mvSettings.setValue("VEF", "Venezuelan Bolivar Fuerte");
        mvSettings.setValue("VND", "Vietnam Dong");
        mvSettings.setValue("XAF", "Central African CFA Franc");
        mvSettings.setValue("XCD", "East Caribbean Dollar");
        mvSettings.setValue("XOF", "West African CFA Franc");
        mvSettings.setValue("YER", "Yemen Rial");
        mvSettings.setValue("ZAR", "South Africa Rand");
        mvSettings.endGroup();

        mvSettings.beginGroup("CurrencyPreset");
        mvSettings.setValue("0Home", "EUR");
        mvSettings.setValue("0Foreign", "USD");
        mvSettings.setValue("1Home", "EUR");
        mvSettings.setValue("1Foreign", "GBP");
        mvSettings.setValue("2Home", "GBP");
        mvSettings.setValue("2Foreign", "USD");
        mvSettings.endGroup();
        mvSettings.setValue("CurrencyPreset", 3);

        mvSettings.beginGroup("UnitAreaName");
        mvSettings.setValue("0", "Square Metre");
        mvSettings.setValue("1", "Square Millimetre");
        mvSettings.setValue("2", "Square Centimetre");
        mvSettings.setValue("3", "Square Kilometre");
        mvSettings.setValue("4", "Square Inch");
        mvSettings.setValue("5", "Square Foot");
        mvSettings.setValue("6", "Square Yard");
        mvSettings.setValue("7", "Square Mile");
        mvSettings.setValue("8", "Hectare");
        mvSettings.setValue("9", "Acre");
        mvSettings.endGroup();

        mvSettings.beginGroup("UnitAreaSymbol");
        mvSettings.setValue("0", "m2");
        mvSettings.setValue("1", "mm2");
        mvSettings.setValue("2", "cm2");
        mvSettings.setValue("3", "km2");
        mvSettings.setValue("4", "in2");
        mvSettings.setValue("5", "ft2");
        mvSettings.setValue("6", "yd2");
        mvSettings.setValue("7", "mi2");
        mvSettings.setValue("8", "ha");
        mvSettings.setValue("9", "ac");
        mvSettings.endGroup();

        mvSettings.beginGroup("UnitAreaValue");
        mvSettings.setValue("0", 1);
        mvSettings.setValue("1", 1e6);
        mvSettings.setValue("2", 1e4);
        mvSettings.setValue("3", 1e-6);
        mvSettings.setValue("4", 1550);
        mvSettings.setValue("5", 10.76391);
        mvSettings.setValue("6", 1.19599);
        mvSettings.setValue("7", 3.861022e-7);
        mvSettings.setValue("8", 1e-4);
        mvSettings.setValue("9", 2.471044e-4);
        mvSettings.endGroup();

        mvSettings.beginGroup("UnitLengthName");
        mvSettings.setValue("0", "Metre");
        mvSettings.setValue("1", "Millimetre");
        mvSettings.setValue("2", "Centimetre");
        mvSettings.setValue("3", "Kilometre");
        mvSettings.setValue("4", "Inch");
        mvSettings.setValue("5", "Foot");
        mvSettings.setValue("6", "Yard");
        mvSettings.setValue("7", "Mile");
        mvSettings.setValue("8", "Nautical Mile");
        mvSettings.endGroup();

        mvSettings.beginGroup("UnitLengthSymbol");
        mvSettings.setValue("0", "m");
        mvSettings.setValue("1", "mm");
        mvSettings.setValue("2", "cm");
        mvSettings.setValue("3", "km");
        mvSettings.setValue("4", "in");
        mvSettings.setValue("5", "ft");
        mvSettings.setValue("6", "yd");
        mvSettings.setValue("7", "mi");
        mvSettings.setValue("8", "nmi");
        mvSettings.endGroup();

        mvSettings.beginGroup("UnitLengthValue");
        mvSettings.setValue("0", 1);
        mvSettings.setValue("1", 1000);
        mvSettings.setValue("2", 100);
        mvSettings.setValue("3", 0.001);
        mvSettings.setValue("4", 39.37008);
        mvSettings.setValue("5", 3.28084);
        mvSettings.setValue("6", 1.093613);
        mvSettings.setValue("7", 6.213712e-4);
        mvSettings.setValue("8", 5.399568e-4);
        mvSettings.endGroup();

        mvSettings.beginGroup("UnitMassName");
        mvSettings.setValue("0", "Kilogram");
        mvSettings.setValue("1", "Milligram");
        mvSettings.setValue("2", "Gram");
        mvSettings.setValue("3", "Ounce");
        mvSettings.setValue("4", "Ounce (troy)");
        mvSettings.setValue("5", "Pound");
        mvSettings.setValue("6", "Ton (Imp.)");
        mvSettings.setValue("7", "Tonne (metric ton)");
        mvSettings.setValue("8", "Ton (U.S.)");
        mvSettings.endGroup();

        mvSettings.beginGroup("UnitMassSymbol");
        mvSettings.setValue("0", "kg");
        mvSettings.setValue("1", "mg");
        mvSettings.setValue("2", "g");
        mvSettings.setValue("3", "oz");
        mvSettings.setValue("4", "oz");
        mvSettings.setValue("5", "lb");
        mvSettings.setValue("6", "tn");
        mvSettings.setValue("7", "t");
        mvSettings.setValue("8", "tn");
        mvSettings.endGroup();

        mvSettings.beginGroup("UnitMassValue");
        mvSettings.setValue("0", 1);
        mvSettings.setValue("1", 1e6);
        mvSettings.setValue("2", 1000);
        mvSettings.setValue("3", 35.27397);
        mvSettings.setValue("4", 32.15074);
        mvSettings.setValue("5", 2.204622);
        mvSettings.setValue("6", 9.842064e-4);
        mvSettings.setValue("7", 0.001);
        mvSettings.setValue("8", 0.001102311);
        mvSettings.endGroup();

        mvSettings.beginGroup("UnitSpeedName");
        mvSettings.setValue("0", "Metre per Second");
        mvSettings.setValue("1", "Kilometre per Second");
        mvSettings.setValue("2", "Kilometre per Hour");
        mvSettings.setValue("3", "Inch per Second");
        mvSettings.setValue("4", "Inch per Minute");
        mvSettings.setValue("5", "Foot per Second");
        mvSettings.setValue("6", "Foot per Minute");
        mvSettings.setValue("7", "Foot per Hour");
        mvSettings.setValue("8", "Mile per Hour");
        mvSettings.setValue("9", "Knott");
        mvSettings.setValue("10", "Mach");
        mvSettings.endGroup();

        mvSettings.beginGroup("UnitSpeedSymbol");
        mvSettings.setValue("0", "m/s");
        mvSettings.setValue("1", "km/s");
        mvSettings.setValue("2", "km/h");
        mvSettings.setValue("3", "ips");
        mvSettings.setValue("4", "ipm");
        mvSettings.setValue("5", "fps");
        mvSettings.setValue("6", "fpm");
        mvSettings.setValue("7", "fph");
        mvSettings.setValue("8", "mph");
        mvSettings.setValue("9", "kn");
        mvSettings.setValue("10", "M");
        mvSettings.endGroup();

        mvSettings.beginGroup("UnitSpeedValue");
        mvSettings.setValue("0", 1);
        mvSettings.setValue("1", 0.001);
        mvSettings.setValue("2", 3.6);
        mvSettings.setValue("3", 39.37008);
        mvSettings.setValue("4", 2362.205);
        mvSettings.setValue("5", 3.28084);
        mvSettings.setValue("6", 196.8504);
        mvSettings.setValue("7", 1.181102e4);
        mvSettings.setValue("8", 2.236936);
        mvSettings.setValue("9", 1.943845);
        mvSettings.setValue("10", 0.00293867);
        mvSettings.endGroup();

        mvSettings.beginGroup("UnitTemperatureName");
        mvSettings.setValue("0", "Celsius");
        mvSettings.setValue("1", "Kelvin");
        mvSettings.setValue("2", "Fahrenheit");
        mvSettings.endGroup();

        mvSettings.beginGroup("UnitTemperatureSymbol");
        mvSettings.setValue("0", "C");
        mvSettings.setValue("1", "K");
        mvSettings.setValue("2", "F");
        mvSettings.endGroup();

        mvSettings.beginGroup("UnitTemperatureValue");
        mvSettings.setValue("0", 0);
        mvSettings.setValue("1", 273.15);
        mvSettings.setValue("2", 32);
        mvSettings.endGroup();

        mvSettings.beginGroup("UnitVolumeName");
        mvSettings.setValue("0", "Cubic Metre");
        mvSettings.setValue("1", "Cubic Centimetre");
        mvSettings.setValue("2", "Millilitre");
        mvSettings.setValue("3", "Centilitre");
        mvSettings.setValue("4", "Litre");
        mvSettings.setValue("5", "Cubic Inch");
        mvSettings.setValue("6", "Cubic Foot");
        mvSettings.setValue("7", "Cubic Yard");
        mvSettings.setValue("8", "Gallon (Imp.)");
        mvSettings.setValue("9", "Gallon (U.S.)");
        mvSettings.setValue("10", "Pint (Imp.)");
        mvSettings.setValue("11", "Pint (U.S.)");
        mvSettings.setValue("12", "Quart (Imp.)");
        mvSettings.setValue("13", "Quart (U.S.)");
        mvSettings.setValue("14", "Fluid Ounce (Imp.)");
        mvSettings.setValue("15", "Fluid Ounce (U.S.)");
        mvSettings.setValue("16", "Table Spoon");
        mvSettings.setValue("17", "Tea Spoon");
        mvSettings.setValue("18", "Barrel (Oil)");
        mvSettings.endGroup();

        mvSettings.beginGroup("UnitVolumeSymbol");
        mvSettings.setValue("0", "m3");
        mvSettings.setValue("1", "cm3");
        mvSettings.setValue("2", "ml");
        mvSettings.setValue("3", "cl");
        mvSettings.setValue("4", "l");
        mvSettings.setValue("5", "in3");
        mvSettings.setValue("6", "ft3");
        mvSettings.setValue("7", "yd3");
        mvSettings.setValue("8", "gal");
        mvSettings.setValue("9", "gal");
        mvSettings.setValue("10", "pt");
        mvSettings.setValue("11", "pt");
        mvSettings.setValue("12", "qt");
        mvSettings.setValue("13", "qt");
        mvSettings.setValue("14", "fl oz");
        mvSettings.setValue("15", "fl oz");
        mvSettings.setValue("16", "tbsp");
        mvSettings.setValue("17", "tsp");
        mvSettings.setValue("18", "bl");;
        mvSettings.endGroup();

        mvSettings.beginGroup("UnitVolumeValue");
        mvSettings.setValue("0", 1);
        mvSettings.setValue("1", 1e6);
        mvSettings.setValue("2", 1e6);
        mvSettings.setValue("3", 1e5);
        mvSettings.setValue("4", 1000);
        mvSettings.setValue("5", 6.102376e4);
        mvSettings.setValue("6", 35.31466);
        mvSettings.setValue("7", 1.30795);
        mvSettings.setValue("8", 219.9692);
        mvSettings.setValue("9", 264.17199999999997);
        mvSettings.setValue("10", 1759.754);
        mvSettings.setValue("11", 2113.377);
        mvSettings.setValue("12", 879.8768);
        mvSettings.setValue("13", 1056.689);
        mvSettings.setValue("14", 3.519508e4);
        mvSettings.setValue("15", 3.381402e4);
        mvSettings.setValue("16", 15e6);
        mvSettings.setValue("17", 5e6);
        mvSettings.setValue("18", 6.289811);;
        mvSettings.endGroup();

        mvSettings.beginGroup("UnitPreset");
        mvSettings.setValue("0UnitType", "Temperature");
        mvSettings.setValue("0Unit1", 0);
        mvSettings.setValue("0Unit2", 2);
        mvSettings.setValue("1UnitType", "Length");
        mvSettings.setValue("1Unit1", 0);
        mvSettings.setValue("1Unit2", 4);
        mvSettings.setValue("2UnitType", "Speed");
        mvSettings.setValue("2Unit1", 2);
        mvSettings.setValue("2Unit2", 8);
        mvSettings.endGroup();
        mvSettings.setValue("UnitPreset", 3);

        mvSettings.setValue("UnitType", "Temperature");
        mvSettings.setValue("Unit1", 0);
        mvSettings.setValue("Unit2", 2);
    }


    mvSettings.sync();
    mvCurrency = mvSettings.value("Currency").toBool();
    updateButtons();
    mvTotal = 0;
    mvCurrencyPreset = mvSettings.value("CurrencyCurrent").toInt();
    mvUnitPreset = mvSettings.value("UnitCurrent").toInt();    
    updateValue(0);
}

void MainWindow::updateValue(int actionType)
{
    double currentValue = ui->lineEdit->text().toDouble();

    switch (mvAction) {
    case 0:
        mvTotal = currentValue;
        break;
    case 1:
        mvTotal += currentValue;
        break;
    case 2:
        mvTotal -= currentValue;
        break;
    case 3:
        mvTotal *= currentValue;
        break;
    case 4:
        mvTotal /= currentValue;
        break;
    }

    QString labelText = ui->label->text();
    QString formatRate;
    float addRate;


    switch (actionType) {
    case 5:
        addRate = mvTotal / 100 * mvSettings.value("TipRate").toDouble();
        mvTotal += addRate;
        mvAction = 0;
        formatRate.setNum(addRate, 'f', 2);
        labelText = "Tip " + formatRate;
        ui->labelSmall->setText(labelText);
        break;
    case 6:
        addRate = mvTotal / 100 * mvSettings.value("TaxRate").toDouble();
        mvTotal += addRate;
        mvAction = 0;
        formatRate.setNum(addRate, 'f', 2);
        labelText = "Tax " + formatRate;
        ui->labelSmall->setText(labelText);
        break;
    default:
        mvAction = actionType;
        break;
    }

    mvClear = true;

    ui->lineEdit->setText(QString::number(mvTotal, 'f', 2));
}

void MainWindow::updateScreen(int valueType)
{
    if (mvClear) {
        ui->lineEdit->clear();
    }

    if (mvUpdated) {
        ui->label->clear();
        mvUpdated = false;
    }

    ui->labelSmall->clear();

    switch (valueType) {
    case 0:
        ui->lineEdit->insert("0");
        break;
    case 1:
        ui->lineEdit->insert("1");
        break;
    case 2:
        ui->lineEdit->insert("2");
        break;
    case 3:
        ui->lineEdit->insert("3");
        break;
    case 4:
        ui->lineEdit->insert("4");
        break;
    case 5:
        ui->lineEdit->insert("5");
        break;
    case 6:
        ui->lineEdit->insert("6");
        break;
    case 7:
        ui->lineEdit->insert("7");
        break;
    case 8:
        ui->lineEdit->insert("8");
        break;
    case 9:
        ui->lineEdit->insert("9");
        break;
    case 10:
        ui->lineEdit->insert(".");
        break;
    case 11:
        ui->lineEdit->backspace();
        break;
    case 12:
        ui->lineEdit->clear();
        ui->label->clear();
        ui->labelSmall->clear();
        mvTotal = 0;
        break;
    }

    mvClear = false;
}

void MainWindow::convertCurrency(QString fromCurrency, QString toCurrency)
{
    double currentValue = ui->lineEdit->text().toDouble();
    double fromRate;
    double toRate;
    double conversionRate;
    bool fromEuro;
    bool toEuro;

    if (fromCurrency == "EUR") {
        fromEuro = true;
    } else {
        fromRate = mvSettings.value("Currency/" + fromCurrency).toDouble();
        fromEuro = false;
    }

    if (toCurrency == "EUR") {
        toEuro = true;
    } else {
        toRate = mvSettings.value("Currency/" + toCurrency).toDouble();
        toEuro = false;
    }

    if (fromEuro) {
        currentValue *= toRate;
    } else if (toEuro) {
        conversionRate = 1 / fromRate;
        currentValue *= conversionRate;
    } else {
        conversionRate = 1 / fromRate;
        conversionRate *= toRate;
        currentValue *= conversionRate;
    }

    mvTotal = currentValue;
    ui->labelSmall->clear();
    ui->lineEdit->setText(QString::number(mvTotal, 'f', 2));
    mvClear = true;
}

void MainWindow::convertUnit(QString fromUnit, QString toUnit)
{
    QString unitType = mvSettings.value("UnitType").toString();
    QString unitGroup = "Unit" + unitType + "Value";
    double currentValue = ui->lineEdit->text().toDouble();
    double fromValue;
    double toValue;
    double conversionValue;
    bool fromDefault;
    bool toDefault;

    mvSettings.beginGroup(unitGroup);

    if (unitType != "Temperature") {
        if (fromUnit == 0) {
            fromDefault = true;
        } else {
            fromValue = mvSettings.value(fromUnit).toDouble();
            fromDefault = false;
        }

        if (toUnit == 0) {
            toDefault = true;
        } else {
            toValue = mvSettings.value(toUnit).toDouble();
            toDefault = false;
        }

        if (fromDefault) {
            currentValue *= toValue;
        } else if (toDefault) {
            conversionValue = 1 / fromValue;
            currentValue *= conversionValue;
        } else {
            conversionValue = 1 / fromValue;
            conversionValue *= toValue;
            currentValue *= conversionValue;
        }
    } else {
        switch (fromUnit.toInt()) {
        case 0:
            switch (toUnit.toInt()) {
            case 1:
                currentValue -= 273.15;
                break;
            case 2:
                currentValue = (currentValue * 9 / 5) + 32;
                break;
            }
            break;
        case 1:
            switch (toUnit.toInt()) {
            case 0:
                currentValue += 273.15;
                break;
            case 2:
                currentValue = (currentValue * 9 / 5) - 459.67;
                break;
            }
            break;
        case 2:
            switch (toUnit.toInt()) {
            case 0:
                currentValue = (currentValue - 32) * 5 / 9;
                break;
            case 1:
                currentValue = (currentValue + 459.67) * 5 / 9;
                break;
            }
            break;
        }
    }


    mvSettings.endGroup();

    mvTotal = currentValue;
    ui->labelSmall->clear();
    ui->lineEdit->setText(QString::number(mvTotal));
    mvClear = true;

}

void MainWindow::updateCurrency()
{
    QNetworkAccessManager manager;
    QEventLoop loop;
    QTimer *timer = new QTimer(this);
    QNetworkRequest *request; // = new QNetworkRequest(QUrl("http://www.ecb.europa.eu/stats/eurofxref/eurofxref-daily.xml"));
    QNetworkReply *reply; // = manager.get(*request);

    request = new QNetworkRequest(QUrl("http://rss.timegenie.com/forex2.xml"));
    reply = manager.get(*request);

    connect(reply, SIGNAL(finished()), &loop, SLOT(quit()));
    connect(timer, SIGNAL(timeout()), &loop, SLOT(quit()));

    ui->label->setText("Time Genie...");

    loop.exec();
    timer->start(10000);
    xml.clear();
    xml.addData(reply->readAll());

    delete reply;

    while (!xml.atEnd()) {
        if (xml.isStartElement()) {
            if (xml.name() == "currency") {
                QXmlStreamAttributes attrs = xml.attributes();
                QStringRef currencyName = attrs.value("code");
                QStringRef currencyRate = attrs.value("rate");
                if (!currencyName.isEmpty()) {
                    mvSettings.setValue("Currency/" + currencyName.toString(), currencyRate.toString());
                }
            }
        }
        xml.readNext();
    }

    delete request;

    request = new QNetworkRequest(QUrl("http://www.ecb.europa.eu/stats/eurofxref/eurofxref-daily.xml"));
    reply = manager.get(*request);

    connect(reply, SIGNAL(finished()), &loop, SLOT(quit()));
    connect(timer, SIGNAL(timeout()), &loop, SLOT(quit()));

    ui->label->setText("ECB...");

    loop.exec();
    timer->start(10000);
    xml.clear();
    xml.addData(reply->readAll());
 
    delete reply;

    while (!xml.atEnd()) {
        if (xml.isStartElement()) {
            if (xml.name() == "Cube") {
                QXmlStreamAttributes attrs = xml.attributes();
                QStringRef currencyTime = attrs.value("time");
                QStringRef currencyName = attrs.value("currency");
                QStringRef currencyRate = attrs.value("rate");
                if (!currencyTime.isEmpty()) {
                    mvSettings.setValue("CurrencyTime", currencyTime.toString());
                }
                if (!currencyName.isEmpty()) {
                    mvSettings.setValue("Currency/" + currencyName.toString(), currencyRate.toString());
                }
            }
        }
        xml.readNext();
    }
    
    mvSettings.setValue("Currency/EUR", 1);

    QDate date = mvSettings.value("CurrencyTime").toDate();
    QString updated = date.toString();

    ui->label->setText(updated);
    mvUpdated = true;
}

void MainWindow::updateButtons()
{
    QString currency1;
    QString currency2;
    QString unitKey;
    QString unit1;
    QString unit2;

    if (mvCurrency) {
        currency1 = mvSettings.value("Currency1").toString();
        currency2 = mvSettings.value("Currency2").toString();
        currency1 += " -> " + mvSettings.value("Currency2").toString();
        currency2 += " -> " + mvSettings.value("Currency1").toString();
        ui->pushButton_NextCurrency->setText("Next Currency");
        ui->pushButton_NextUnit->setText("Unit");
    } else {
        unitKey = "Unit" + mvSettings.value("UnitType").toString() + "Name";
        unit1 = mvSettings.value("Unit1").toString();
        unit2 = mvSettings.value("Unit2").toString();
        mvSettings.beginGroup(unitKey);
        currency1 = mvSettings.value(unit1).toString();
        currency2 = mvSettings.value(unit2).toString();
        currency1 += " -> " + mvSettings.value(unit2).toString();
        currency2 += " -> " + mvSettings.value(unit1).toString();
        mvSettings.endGroup();
        ui->pushButton_NextCurrency->setText("Currency");
        ui->pushButton_NextUnit->setText("Next Unit");
    }

    ui->pushButton_Currency1->setText(currency1);
    ui->pushButton_Currency2->setText(currency2);
}

void MainWindow::on_pushButton_1_clicked()
{
    updateScreen(1);
}

void MainWindow::on_pushButton_2_clicked()
{
    updateScreen(2);
}

void MainWindow::on_pushButton_3_clicked()
{
    updateScreen(3);
}

void MainWindow::on_pushButton_4_clicked()
{
    updateScreen(4);
}

void MainWindow::on_pushButton_5_clicked()
{
    updateScreen(5);
}

void MainWindow::on_pushButton_6_clicked()
{
    updateScreen(6);
}

void MainWindow::on_pushButton_7_clicked()
{
    updateScreen(7);
}

void MainWindow::on_pushButton_8_clicked()
{
    updateScreen(8);
}

void MainWindow::on_pushButton_9_clicked()
{
    updateScreen(9);
}

void MainWindow::on_pushButton_0_clicked()
{
    updateScreen(0);
}

void MainWindow::on_pushButton_Dot_clicked()
{
    updateScreen(10);
}

void MainWindow::on_pushButton_Del_clicked()
{
    updateScreen(11);
}

void MainWindow::on_pushButton_Clear_clicked()
{
    updateScreen(12);
}

void MainWindow::on_pushButton_Enter_clicked()
{
    updateValue(0);
}

void MainWindow::on_pushButton_Plus_clicked()
{
    updateValue(1);
}

void MainWindow::on_pushButton_Minus_clicked()
{
    updateValue(2);
}

void MainWindow::on_pushButton_Multiply_clicked()
{
    updateValue(3);
}

void MainWindow::on_pushButton_Divide_clicked()
{
    updateValue(4);
}

void MainWindow::on_pushButton_Tip_clicked()
{
    if (mvCurrency) {
        updateValue(5);
    }
}

void MainWindow::on_pushButton_Tax_clicked()
{
    if (mvCurrency) {
        updateValue(6);
    }
}


void MainWindow::on_pushButton_Currency1_clicked()
{
    if (mvCurrency) {
        QString currency1 = mvSettings.value("Currency1").toString();
        QString currency2 = mvSettings.value("Currency2").toString();
        convertCurrency(currency1, currency2);
        ui->label->setText(currency2);
    } else {
        QString unit1 = mvSettings.value("Unit1").toString();
        QString unit2 = mvSettings.value("Unit2").toString();
        QString unitKey = "Unit" + mvSettings.value("UnitType").toString() + "Symbol/" + unit2;
        QString unitSymbol = mvSettings.value(unitKey).toString();
        convertUnit(unit1, unit2);
        ui->label->setText(unitSymbol);
    }
}

void MainWindow::on_pushButton_Currency2_clicked()
{
    if (mvCurrency) {
        QString currency1 = mvSettings.value("Currency1").toString();
        QString currency2 = mvSettings.value("Currency2").toString();
        convertCurrency(currency2, currency1);
        ui->label->setText(currency1);
    } else {
        QString unit1 = mvSettings.value("Unit1").toString();
        QString unit2 = mvSettings.value("Unit2").toString();
        QString unitKey = "Unit" + mvSettings.value("UnitType").toString() + "Symbol/" + unit1;
        QString unitSymbol = mvSettings.value(unitKey).toString();
        convertUnit(unit2, unit1);
        ui->label->setText(unitSymbol);
    }
}

void MainWindow::on_actionHelp_triggered()
{
    helpDialog = new Help;
    helpDialog->exec();
}

void MainWindow::on_actionAbout_triggered()
{
    aboutDialog = new About;
    aboutDialog->exec();
}

void MainWindow::on_actionDonate_triggered()
{
    QDesktopServices::openUrl(QUrl("https://www.paypal.com/cgi-bin/webscr?cmd=_donations&business=sascha.makela@gmail.com&lc=LT&item_name=STM%20Software%20-%20Currency%20Converter&currency_code=EUR&bn=PP%2dDonationsBF%3abtn_donateCC_LG%2egif%3aNonHosted"));
}

void MainWindow::on_pushButton_NextCurrency_clicked()
{
    int countPreset = mvSettings.value("CurrencyPreset").toInt();
    countPreset -= 1;

    if (mvCurrency) {
        if (mvCurrencyPreset < countPreset) {
            mvCurrencyPreset += 1;
        } else {
            mvCurrencyPreset = 0;
        }
    } else {
        mvTotal = 0;
        ui->labelSmall->clear();
        ui->label->clear();
        ui->lineEdit->clear();
        ui->lineEdit->setValidator(new QDoubleValidator(0, 0, 2, this));
        mvCurrency = true;
    }

    QString keyHome = "CurrencyPreset/" + QString::number(mvCurrencyPreset) + "Home";
    QString keyForeign = "CurrencyPreset/" + QString::number(mvCurrencyPreset) + "Foreign";
    QString currencyHome = mvSettings.value(keyHome).toString();
    QString currencyForeign = mvSettings.value(keyForeign).toString();

    mvSettings.setValue("Currency1", currencyHome);
    mvSettings.setValue("Currency2", currencyForeign);
    mvSettings.setValue("CurrencyCurrent", mvCurrencyPreset);    
    updateButtons();
}

void MainWindow::on_pushButton_NextUnit_clicked()
{
    int countPreset = mvSettings.value("UnitPreset").toInt();
    countPreset -= 1;

    if (!mvCurrency) {
        if (mvUnitPreset < countPreset) {
            mvUnitPreset += 1;
        } else {
            mvUnitPreset = 0;
        }
    } else {
        mvTotal = 0;
        ui->labelSmall->clear();
        ui->label->clear();
        ui->lineEdit->clear();
        ui->lineEdit->setValidator(new QDoubleValidator(0, 0, 15, this));
        mvCurrency = false;
    }

    QString keyUnit1 = "UnitPreset/" + QString::number(mvUnitPreset) + "Unit1";
    QString keyUnit2 = "UnitPreset/" + QString::number(mvUnitPreset) + "Unit2";
    QString keyType = "UnitPreset/" + QString::number(mvUnitPreset) + "UnitType";
    QString unit1 = mvSettings.value(keyUnit1).toString();
    QString unit2 = mvSettings.value(keyUnit2).toString();
    QString unitType = mvSettings.value(keyType).toString();

    mvSettings.setValue("Unit1", unit1);
    mvSettings.setValue("Unit2", unit2);
    mvSettings.setValue("UnitType", unitType);
    mvSettings.setValue("UnitCurrent", mvUnitPreset);    
    updateButtons();
}

bool MainWindow::eventFilter(QObject *obj, QEvent *event)
{
    if (event->type() == QEvent::Close) {
        initialSettings();
        return true;
    } else {
        return QObject::eventFilter(obj, event);
    }
}



void MainWindow::on_pushButton_Negate_clicked()
{
    double currentValue = ui->lineEdit->text().toDouble();
    currentValue *= -1;
    ui->lineEdit->clear();
    ui->lineEdit->setText(QString::number(currentValue));
}

void MainWindow::on_actionCurrency_triggered()
{
    currencySettings = new CurrencySettings(this);
    currencySettings->installEventFilter(this);
    currencySettings->show();
}

void MainWindow::on_actionUpdate_triggered()
{
    ui->lineEdit->clear();
    ui->labelSmall->clear();
    updateCurrency();
}

void MainWindow::on_actionUnit_triggered()
{
    unitSettings = new UnitSettings(this);
    unitSettings->installEventFilter(this);
    unitSettings->show();
}
