#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <QMainWindow>
#include <QSettings>
#include <QDesktopServices>
#include <QtNetwork>
#include <QTimer>
#include "currency.h"
#include "about.h"
#include "help.h"

namespace Ui {
    class MainWindow;
}

class MainWindow : public QMainWindow {
    Q_OBJECT
public:
    MainWindow(QWidget *parent = 0);
    ~MainWindow();

protected:
    void changeEvent(QEvent *e);

private:
    Ui::MainWindow *ui;
    QSettings mvSettings;
    QXmlStreamReader xml;
    Currency *currencyDialog;
    About *aboutDialog;
    Help *helpDialog;
    double mvTotal;
    int mvAction;
    bool mvClear;
    bool mvUpdated;

    void updateValue(int actionType);
    void updateScreen(int valueType);
    void convertCurrency(QString fromCurrency, QString toCurrency);
    void updateCurrency();
    void updateButtons();
    void initialSettings();

private slots:
    void on_pushButton_Update_clicked();
    void on_actionDonate_triggered();
    void on_actionAbout_triggered();
    void on_actionHelp_triggered();
    void on_pushButton_SetCurrency_clicked();
    void on_pushButton_Currency2_clicked();
    void on_pushButton_Currency1_clicked();
    void on_pushButton_Enter_clicked();
    void on_pushButton_Tax_clicked();
    void on_pushButton_Tip_clicked();
    void on_pushButton_Divide_clicked();
    void on_pushButton_Multiply_clicked();
    void on_pushButton_Minus_clicked();
    void on_pushButton_Plus_clicked();
    void on_pushButton_Clear_clicked();
    void on_pushButton_Del_clicked();
    void on_pushButton_Dot_clicked();
    void on_pushButton_0_clicked();
    void on_pushButton_9_clicked();
    void on_pushButton_8_clicked();
    void on_pushButton_7_clicked();
    void on_pushButton_6_clicked();
    void on_pushButton_5_clicked();
    void on_pushButton_4_clicked();
    void on_pushButton_3_clicked();
    void on_pushButton_2_clicked();
    void on_pushButton_1_clicked();
};

#endif // MAINWINDOW_H
