/*
*  currency exchange widget for the maemo desktop.
*  Copyright (C) 2010 binop consulting group
*  
*  This program is free software; you can redistribute it and/or modify
*  it under the terms of the GNU General Public License as published by
*  the Free Software Foundation; either version 2 of the License, or
*  (at your option) any later version.
*  
*  This program is distributed in the hope that it will be useful,
*  but WITHOUT ANY WARRANTY; without even the implied warranty of
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*  GNU General Public License for more details.
*  
*  You should have received a copy of the GNU General Public License
*  along with this program; if not, write to the Free Software
*  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <errno.h>
#include <string.h>
#include <netdb.h>
#include <sys/types.h>
#include <netinet/in.h>
#include <sys/socket.h>
#include <arpa/inet.h>
#include <curl/curl.h>

#include "lib-currency-home-widget.h"



struct write_result {
        char *data;
        int pos;
};


size_t write_to_string( void *ptr, size_t size, size_t nmemb, void *stream)
{
       
        struct write_result *result = (struct write_result *)stream;


        if ( result->pos + size*nmemb >= BUFFER_SIZE - 1) {
                fprintf(stderr, "curl error: buffer too small\n");
                exit(EXIT_FAILURE);
        }


        memcpy(result->data + result->pos, ptr, size *nmemb);

        result->pos += size*nmemb;

        return size*nmemb;
}

char * get_html(char *url) {
       
        CURL *curl;
        char *string;
        
        struct write_result  write_result;
         
        write_result.data = malloc(BUFFER_SIZE);
        string = malloc(BUFFER_SIZE);
        if ( !write_result.data || !string )
        {
                fprintf(stderr, "Error allocating %d bytes.\n", BUFFER_SIZE);
                exit(EXIT_FAILURE);
        }


        write_result.pos = 0;


        curl = curl_easy_init();
        if ( curl) {
                curl_easy_setopt(curl, CURLOPT_URL, url);
                curl_easy_setopt(curl, CURLOPT_WRITEFUNCTION, write_to_string);
                curl_easy_setopt(curl, CURLOPT_WRITEDATA, &write_result);
                curl_easy_perform(curl);
        }
        else {
                fprintf(stderr, "Curl Failed to perform, is internet connection on?");
                return NULL;
        }
       
        write_result.data[write_result.pos] = '\0';


        strcpy (string, write_result.data);
        free(write_result.data);
        curl_easy_cleanup(curl);        
        curl_global_cleanup(); 

        return  string;
}

