/*
*  currency exchange widget for the maemo desktop.
*  Copyright (C) 2010 binop consulting group
*  
*  This program is free software; you can redistribute it and/or modify
*  it under the terms of the GNU General Public License as published by
*  the Free Software Foundation; either version 2 of the License, or
*  (at your option) any later version.
*  
*  This program is distributed in the hope that it will be useful,
*  but WITHOUT ANY WARRANTY; without even the implied warranty of
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*  GNU General Public License for more details.
*  
*  You should have received a copy of the GNU General Public License
*  along with this program; if not, write to the Free Software
*  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <locale.h>

#include <gconf/gconf-client.h>
#include "lib-currency-home-widget.h"


GConfClient *client;

extern void init_currency(currency **cur);
extern char *currencies[49];
extern int n_currencies;

void save_config(CurrencyWidget **plug) {
  
    char tmp[100];

    sprintf(tmp, "%s-%s", GCONF_KEY_CURRENCY_FROM, (*plug)->id);
    gconf_client_set_int ( client,  tmp, (*plug)->curset->type, NULL);
    tmp[0] = '\0';
    sprintf(tmp, "%s-%s", GCONF_KEY_CURRENCY_TO, (*plug)->id);
    gconf_client_set_int ( client,  tmp, (*plug)->curset->active_currency->type, NULL);
    tmp[0] = '\0';
    sprintf(tmp, "%s-%s", GCONF_KEY_CURRENCY_UPDATE_INTERVAL, (*plug)->id);
    gconf_client_set_int ( client,  tmp, (*plug)->curset->update_interval, NULL);

}

void load_config(CurrencyWidget **plug) {

    struct lconv * l = localeconv();
    int i;


    client = gconf_client_get_default();

    if ( !client ) {
        fprintf(stderr, "Could not initialize GConfClient!\n");
        exit(EXIT_FAILURE);
    }

    // check for errors 
    //
    if ( (*plug)->curset->name != NULL ) {
        free (( *plug)->curset->name);
    }
    (*plug)->curset->name = malloc(sizeof(5));

    if ( !(*plug)->curset->name  ) {
        fprintf(stderr, "Could not allocate memory in load_config!\n");
        exit(EXIT_FAILURE);
    }



    init_currency(&(*plug)->curset->active_currency);


    char tmp[100];
    sprintf(tmp, "%s-%s", GCONF_KEY_CURRENCY_FROM, (*plug)->id);

    if ( gconf_client_get_int( client, tmp, NULL) == 0 ) {
        (*plug)->curset->type = 0;
        for ( i  = 0; i < n_currencies; i++ ) {
            if ( strstr(l->int_curr_symbol, currencies[i]) != NULL ) {
                (*plug)->curset->type = i + 1 ;
            }
        }

        if ( (*plug)->curset->type == 0 ) {
            (*plug)->curset->type = USD;
        }
        gconf_client_set_int ( client, tmp , (*plug)->curset->type , NULL);
    } 
    else {
        (*plug)->curset->type = gconf_client_get_int (client, tmp, NULL);
    }
    
    tmp[0] = '\0';
    sprintf(tmp, "%s-%s", GCONF_KEY_CURRENCY_TO, (*plug)->id);


    if ( gconf_client_get_int(client, tmp, NULL) == 0 ) {
        (*plug)->curset->active_currency->type = USD;
        gconf_client_set_int ( client, tmp, USD, NULL);
    }
    else  {
        (*plug)->curset->active_currency->type = gconf_client_get_int (client, tmp, NULL);
    }

    tmp[0] = '\0';
    sprintf(tmp, "%s-%s", GCONF_KEY_CURRENCY_UPDATE_INTERVAL, (*plug)->id);

    if ( gconf_client_get_int ( client, tmp , NULL) == 0) {
        (*plug)->curset->update_interval = 4;
        gconf_client_set_int ( client, tmp, 4, NULL);
    }
    else {
        (*plug)->curset->update_interval = gconf_client_get_int (client, tmp, NULL);
    }
    
    tmp[0] = '\0';
    sprintf(tmp, "%s-%s", GCONF_KEY_CURRENCY_LAST_UPDATE, (*plug)->id);

    if ( gconf_client_get_int ( client, tmp, NULL) == 0 ) {
        time(&(*plug)->curset->update_interval);
        gconf_client_set_int ( client, tmp, (*plug)->curset->update_interval , NULL);
    }
    else {
        (*plug)->curset->last_update = gconf_client_get_int (client, tmp, NULL);
    }

}
