#include "todolistmodel.h"

#include <QOrganizerTodoProgress>
#include <QFont>

TodoListModel::TodoListModel(QObject *parent) :
    QAbstractListModel(parent)
{
}

int TodoListModel::rowCount(const QModelIndex &parent) const{
    if (parent.isValid())
        return 0;
    else
        return todos.size();
}

QVariant TodoListModel::data(const QModelIndex &index, int role) const{
    //    qDebug() << index.row() << role;
    if (!index.isValid())
        return QVariant();
    if (role == Qt::DisplayRole) {
        //        qDebug() << "user role: " << todos.at(index.row()).displayLabel();
        return todos.at(index.row()).displayLabel();
    } else if (role == Qt::EditRole) {
        const QOrganizerItem &item = todos.at(index.row());
        return QVariant::fromValue<QOrganizerItem>(item);
    } else if (role == Qt::FontRole) {
        QFont font;
        QOrganizerItem item = todos.at(index.row());
        if (item.type() != QOrganizerItemType::TypeTodo)
            return font;

        QOrganizerTodo todo = static_cast<QOrganizerTodo>(item);
        if (todo.status() == QOrganizerTodoProgress::StatusComplete) {
            font.setStrikeOut(true);
            return font;
        }
    }
    return QVariant();
}

bool TodoListModel::setData ( const QModelIndex &index, const QVariant &value, int role) {
    if (role == Qt::EditRole) {
        beginInsertRows(index, index.row(), index.row());
        todos.replace(index.row(), value.value<QOrganizerItem>());
        endInsertRows();
    }
    return true;
}

void TodoListModel::add(const QOrganizerItem &todo) {
    beginInsertRows(QModelIndex(), 0, 0);
    todos.insert(0, todo);
    endInsertRows();
}
