// checksum 0x9a77 version 0x30002
/*
  This file was generated by the Mobile Qt Application wizard of Qt Creator.
  MainWindow is a convenience class containing mobile device specific code
  such as screen orientation handling.
  It is recommended not to modify this file, since newer versions of Qt Creator
  may offer an updated version of it.
*/

#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include "todolistmodel.h"

#include <QtGui/QMainWindow>
#include <QXmlStreamReader>
#include <QGeoAreaMonitor>
#include <QGeoPositionInfo>
#include <QGeoPositionInfoSource>
#include <QTimer>
#include <QModelIndex>
#include <QAbstractButton>
#include <QThread>
#include <QOrganizerCollectionFetchRequest>
#include <QOrganizerCollectionSaveRequest>
#include <QMetaType>
#include <QNetworkReply>

#include <QDeclarativeView>
#include <QDeclarativeItem>
#include <QDeclarativeEngine>

#if defined(Q_OS_SYMBIAN)
#include <QOrganizerManager>
#include <QOrganizerTodo>
#include <QOrganizerItemVisualReminder>
#include <QGeoBoundingCircle>
#include <QSystemNetworkInfo>
#else
#include <QtOrganizer/QOrganizerItemVisualReminder>
#include <QtLocation/QGeoBoundingCircle>
#include <QtSystemInfo/QSystemNetworkInfo>
#include <QtOrganizer/QOrganizerManager>
#include <QtOrganizer/QOrganizerTodo>
#endif

QTM_USE_NAMESPACE

namespace Ui {
    class MainWindow;
}

class MainWindow : public QMainWindow
{
    Q_OBJECT
public:
    enum ScreenOrientation {
        ScreenOrientationLockPortrait,
        ScreenOrientationLockLandscape,
        ScreenOrientationAuto
    };

    explicit MainWindow(QWidget *parent = 0);
    virtual ~MainWindow();

    void setOrientation(ScreenOrientation orientation);
    void showExpanded();

signals:
    void stop();

private slots:
    void on_pushButton_clicked();
    void positionUpdated(const QGeoPositionInfo &update);
    void check();
    void itemsChanged(QList<QOrganizerItemId> list);
    void handleDelete(QOrganizerItemId id);
    void on_listView_clicked(const QModelIndex &index);
    void replyFinished(QNetworkReply* reply); // cellid response
    void cellIdChanged(int i);
    void refreshView();

    void on_actionAbout_triggered();

private:
    Ui::MainWindow *ui;
    QXmlStreamReader xml;
    QOrganizerManager organizer;
    QTimer timer;
    QList<QOrganizerTodo> reminders;
    TodoListModel *todos;
    QOrganizerCollectionFetchRequest fetchReq;
    QOrganizerCollectionSaveRequest saveReq;
    QGeoPositionInfo *cur_pos;
    QSystemNetworkInfo *in;
    QDeclarativeView* map_view;

    QString parseLocation();
    void updateAlarm(QString label);
    QByteArray GetFormPostData(int cellTowerId, int mobileCountryCode,
            int mobileNetworkCode, int locationAreaCode);
    void Shift(QByteArray& data, int startIndex, int leftOperand);
    double GetCode(QByteArray& data, int startIndex);
    QDeclarativeView* getMapView();
};

#endif // MAINWINDOW_H
