import QtQuick 1.0

Rectangle {
    id: settings_state
    x: 480
    width: workspace.width
    height: workspace.height
    color: "black"
    radius: workspace.radius
    opacity: 0.8
    z: 5

    property alias opacity_stopwatch: stopwatch_check.opacity
    property alias opacity_waittime: waittime_check.opacity

    Rectangle {
        id: settingswindow
        width: 400
        height: 250
        border.color: "#aaaaaa"
        anchors.centerIn: parent
        color: "white"
        radius: 15

        Text {
            id: setting_title
            anchors.left: parent.left
            anchors.leftMargin: 10
            anchors.bottom: parent.top
            anchors.bottomMargin: 5
            text: "settings:"
            font.family: "Nokia Pure Text Light"
            font.pointSize: 32
            color: "white"
        }

        Text {
            id: settings_close
            anchors.right: parent.right
            anchors.bottom: parent.top
            anchors.bottomMargin: 10
            text: "x"
            font.family: "Nokia Pure Text"
            font.pointSize: 32
            color: "white"

            MouseArea{
                anchors.fill: parent
                onClicked: {
                    workspace.state = "settings2normal"
                }
            }
        }

        Text {
            id: stopwatch
            anchors.left: parent.left
            anchors.leftMargin: 10
            anchors.top: parent.top
            anchors.topMargin: 65
            text: "stopwatch only:"
            font.family: "Nokia Pure Text"
            font.pointSize: 24
            color: "black"
        }

        Text {
            id: wait_time
            anchors.left: parent.left
            anchors.leftMargin: 10
            anchors.top: parent.top
            anchors.topMargin: 150
            text: "inspection time:"
            font.family: "Nokia Pure Text"
            font.pointSize: 24
            color: "black"
        }

        Text {
            id: wait_time_info
            anchors.left: parent.left
            anchors.leftMargin: 10
            anchors.top: wait_time.bottom
            anchors.topMargin: 2
            text: "15 Sec."
            font.family: "Nokia Pure Text"
            font.pointSize:12
            color: "black"
        }
    }


        Rectangle {
            id: stopwatch_checkbox
            anchors.left: settingswindow.left
            anchors.leftMargin: 300
            anchors.top: settingswindow.top
            anchors.topMargin: 50
            width: 70
            height: 70
            color: "white"
            radius: 15
            border.color: "#aaaaaa"

            MouseArea {
                objectName: "stopwatch_check_mouse"
                anchors.fill: parent
                onClicked: {
                    if (stopwatch_check.opacity == 1.0) {stopwatch_check.opacity = 0.0; scramble_title.opacity = 1.0; scramble.opacity = 1.0;
                        scramble2.opacity = 1.0; record.opacity = 1.0; average.opacity = 1.0; last.opacity = 1.0}

                    else {stopwatch_check.opacity = 1.0; scramble_title.opacity = 0.0; scramble.opacity = 0.0;
                        scramble2.opacity = 0.0; record.opacity = 0.0; average.opacity = 0.0; last.opacity = 0.0}
                                    }
            }

            Rectangle {
            id: stopwatch_check
            objectName: "stopwatch_check"
            anchors.centerIn: stopwatch_checkbox
            width: 50
            height: 50
            opacity: 0.0
            radius: 15
            color: "#5ab500"
        }
}

        Rectangle {
            id: wait_time_checkbox
            anchors.left: settingswindow.left
            anchors.leftMargin: 300
            anchors.top: settingswindow.top
            anchors.topMargin: 130
            width: 70
            height: 70
            color: "white"
            radius: 15
            border.color: "#aaaaaa"

            MouseArea {
                objectName: "waittime_check_mouse"
                anchors.fill: parent
                onClicked: {
                    if (waittime_check.opacity == 1.0) {waittime_check.opacity = 0.0}
                    else {waittime_check.opacity = 1.0}
                }
        }


        Rectangle {
            id: waittime_check
            objectName: "waittime_check"
            anchors.centerIn: wait_time_checkbox
            width: 50
            height: 50
            opacity: 0.0
            radius: 15
            color: "#5ab500"
        }
    }
}
