#!/usr/bin/python2.5

# Copyright (c) 2010 Christos Zamantzas
# Licenced under GPLv2

#######################################################################
##  CSSUfeatures  -  Configuration UI for the Community SSU features ##
#######################################################################

##Author: Christos Zamantzas <christos.zamantzas@gmail.com>
Version = '0.3-1'

import os
import sys
import time

from PyQt4.QtGui import *
from PyQt4.QtCore import *
from PyQt4.QtMaemo5 import *
from CSSUfeaturesUI import *

##############################################################

PathApp             = '/opt/CSSUfeatures'             # application path
PathSystem          = '/usr/share/hildon-desktop/'    # main path
ConfigSystem        = 'transitions.ini'               # name of system config file
PathTheme           = '/etc/hildon/theme/'            # main path (if themes are in place)
ConfigTheme         = 'transitions.ini'               # name of system config file (if themes are in place)
PathTemp            = '/home/user/.CSSUfeatures/'     # temp path of files
ConfigTempSystem    = 'CSSUfeatures_temp_system'      # name of temp config file from/for system
ConfigTempTheme     = 'CSSUfeatures_temp_theme'       # name of temp config file from/for theme

##############################################################

def CheckFile(Path, File):       
    ''' Check if a file exists. '''

    try:
        f = open(Path + File, 'r')
        f.close()
    except:
        return False
    else:
        return True

def showMessage(message):        
    ''' Method to display a message to the user that waits for an action. '''

    os.system('dbus-send --type=method_call --dest=org.freedesktop.Notifications \
               /org/freedesktop/Notifications \
               org.freedesktop.Notifications.SystemNoteDialog \
               string:"%s" uint32:0 string:"OK"' % message)          

def showQuickMessage(message):   
    ''' Method to display shortly a message to the user. '''

    os.system('dbus-send --type=method_call --dest=org.freedesktop.Notifications \
               /org/freedesktop/Notifications \
               org.freedesktop.Notifications.SystemNoteInfoprint \
               string:"%s"' % message)          
               
def doUpdateConfigSystem():            
    ''' Update the config file of the system with the edited. '''

    time.sleep(1)
    try:
       os.system('sudo %s/updateTransitions copyTempSystem' % PathApp)
    except:
       return False
    else: 
       return True

def doUpdateConfigTheme():            
    ''' Update the config file of the theme with the edited. '''

    time.sleep(1)
    try:
       os.system('sudo %s/updateTransitions copyTempTheme' % PathApp)
    except:
       return False
    else: 
       return True
       
class CSSUfeaturesAbout(QtGui.QMainWindow):
    '''About Window'''
    def __init__(self, parent=None):
        QMainWindow.__init__(self,parent)
        self.parent = parent
        self.setAttribute(Qt.WA_Maemo5AutoOrientation, True)
        self.setAttribute(Qt.WA_Maemo5StackedWindow, True)
        self.setWindowTitle("CSSUfeatures About")

        aboutScrollArea = QScrollArea(self)
        aboutScrollArea.setWidgetResizable(True)
        awidget = QWidget(aboutScrollArea)
        awidget.setMinimumSize(470,1000)
        awidget.setSizePolicy( QSizePolicy.Expanding, QSizePolicy.Expanding )
        aboutScrollArea.setSizePolicy( QSizePolicy.Expanding, QSizePolicy.Expanding )
        #Kinetic scroller is available on Maemo and should be on meego
        try:
            scroller = aboutScrollArea.property("kineticScroller").toPyObject()
            scroller.setEnabled(True)
        except:
            pass

        aboutLayout = QVBoxLayout(awidget)

        aboutIcon = QLabel()
        aboutIcon.setPixmap( QIcon.fromTheme('CSSUfeatures').pixmap(48,48) )
        aboutIcon.setAlignment( Qt.AlignCenter or Qt.AlignHCenter )
        aboutIcon.resize(128,128)
        aboutLayout.addWidget(aboutIcon)

        aboutLabel = QLabel('''<center><b>CSSU features</b> %s
                                   <br>
                                   <br>
                                   <b>The CSSU Features application is 
                                   <br>a user interface to the configuration 
                                   <br>of several parameters enabled  
                                   <br>by the Community SSU updates.</b>
                                   <br>
                                   <br>Licenced under GPLv2
                                   <br>by <b>Christos Zamantzas</b> (Saturn)
                                   <br>
                                   <br>It provides the ability to change a number 
                                   <br>of parameters while in operation by  
                                   <br>modifing options in the transitions.ini  
                                   <br>configuration file. 
                                   <br>
                                   <br>
                                   <b>Additional information on the usage, 
                                   <br>settings and implications can be found 
                                   <br>in the wiki page</b>
                                   <br>
                                   <br>
                                   <br><b>Thanks to :</b>
                                   <br><b>Benoit HERVIER</b> at http://khertan.net/
                                   <br>for the code used in this about window
                                   <br>and the pyPackager utility.
                                   <br>
                                   </center>''' % Version)
        aboutLayout.addWidget(aboutLabel)
        self.bugtracker_button = QPushButton('BugTracker')
        self.bugtracker_button.clicked.connect(self.open_bugtracker)
        self.website_button = QPushButton('Wiki Page')
        self.website_button.clicked.connect(self.open_website)
        awidget2 = QWidget()
        buttonLayout = QHBoxLayout(awidget2)        
        buttonLayout.addWidget(self.bugtracker_button)
        buttonLayout.addWidget(self.website_button)
        aboutLayout.addWidget(awidget2)
        
        awidget.setLayout(aboutLayout)
        aboutScrollArea.setWidget(awidget)
        self.setCentralWidget(aboutScrollArea)
        self.show()        
        
    def open_website(self):
        QDesktopServices.openUrl(QUrl('http://wiki.maemo.org/Community_SSU/Features'))
    def open_bugtracker(self):
        QDesktopServices.openUrl(QUrl('https://bugs.maemo.org'))

class MyMainWindow(QtGui.QMainWindow):
        def __init__(self, parent=None):
             
             ##Build parent user interface
             QtGui.QWidget.__init__(self, parent)
             self.ui = Ui_CSSUfeaturesUI()
             self.ui.setupUi(self)
             ##self.setAttribute(Qt.WA_Maemo5AutoOrientation, True)
             self.setAttribute(Qt.WA_Maemo5StackedWindow, True)
             
             ##Connect the GUI Buttons with actions
               ##Create Settings
             QtCore.QObject.connect(self.ui.btnCreateConfig, QtCore.SIGNAL('clicked()'), self.doCreateConfig)
             QtCore.QObject.connect(self.ui.btnSetCurrent, QtCore.SIGNAL('clicked()'), self.doSetCurrent)
             QtCore.QObject.connect(self.ui.btnSetDefault, QtCore.SIGNAL('clicked()'), self.doSetDefault)
             
               ##Connect Menu Buttons 
             QtCore.QObject.connect(self.ui.actionQuit, QtCore.SIGNAL('triggered()'), QtGui.qApp, QtCore.SLOT('quit()'))
             QtCore.QObject.connect(self.ui.actionAbout, QtCore.SIGNAL('triggered()'), self.doAbout)
             QtCore.QObject.connect(self.ui.actionRestoreDefaults, QtCore.SIGNAL('triggered()'), self.doRestoreDefaults)
             
             ##Set current values in the GUI
             #self.doSetCurrent()
             
        ##Create Methods
                
        def doAbout(self):
        
             stackwindow = CSSUfeaturesAbout(self)
             stackwindow.show()

        def doRestoreDefaults(self):
             ''' Restore the default configuration file.'''
             
             message = 'Please wait. Update in progress..'
             showQuickMessage(message)
             
             try:
                 os.system('sudo %s/updateTransitions copyDefault' % PathApp)
             except:
                 message = 'The default transitions.ini file could not be restored to the system.'
             else: 
                 message = 'The default transitions.ini file have been restored to the system.\n\nINFO: Some of its settings will appear on the next reboot.'
                 
             showMessage(message)
             
        def doSetCurrent(self): ##FIXME: implement method!!!    
             ''' Set CURRENT values in the GUI''' 
           
             #self.ui.comboBox.setCurrentIndex(zoom_on_press)
             #self.ui.comboBox.setCurrentIndex(parallax)
             #self.ui.comboBox.setCurrentIndex(blurless)
             #self.ui.comboBox.setCurrentIndex(taskswitcher)
             #self.ui.comboBox.setCurrentIndex(zaxisrotation)
             #self.ui.comboBox.setCurrentIndex(forcerotation)
             #self.ui.comboBox.setCurrentIndex(tactilepopups)
             
             message = 'Displaying the CURRENT configuration options feature is not yet implemented.'
             showMessage(message)
             # message = 'The CURRENT configuration options are shown.'
             # showQuickMessage(message)

        def doSetDefault(self): ##FIXME: implement method!!!    
             ''' Set DEFAULT values in the GUI''' 

             self.ui.comboBoxBlurless.setCurrentIndex(0)
             self.ui.comboBoxTaskSwitcher.setCurrentIndex(0)
             self.ui.comboBoxRotationAxis.setCurrentIndex(0)
             self.ui.comboBoxForcedRotation.setCurrentIndex(0)
             self.ui.comboBoxTactile.setCurrentIndex(0)
             self.ui.comboBoxZoomPress.setCurrentIndex(0)
             self.ui.lineEditParallax.setText('1.3')
             
             message = 'The DEFAULT configuration options are shown.'
             showQuickMessage(message)
             
        def doCreateConfig(self):        
             ''' Create the new configuration file'''
             
             message = 'Please wait. Update in progress..'
             showQuickMessage(message)

             ##Read GUI.
             Blurless        = self.ui.comboBoxBlurless.currentIndex()
             TaskSwitcher    = self.ui.comboBoxTaskSwitcher.currentIndex()
             RotationAxis    = self.ui.comboBoxRotationAxis.currentIndex()
             ForcedRotation  = self.ui.comboBoxForcedRotation.currentIndex()
             Tactile         = self.ui.comboBoxTactile.currentIndex()
             ZoomPress       = self.ui.comboBoxZoomPress.currentIndex()
             Parallax        = self.ui.lineEditParallax.text()

             #Update of the System config file.
             os.rename( PathTemp + ConfigTempSystem, PathTemp + ConfigTempSystem + "~" )
             destination = open( PathTemp + ConfigTempSystem, "w" )
             source = open( PathTemp + ConfigTempSystem + "~", "r" )
             for Line in source:
                 if   Line.startswith("zoom_on_press"):
                     destination.write('zoom_on_press = %s\n' % ZoomPress)
                 elif Line.startswith("parallax"):
                     destination.write('parallax = %s\n' % Parallax)
                 elif Line.startswith("blurless"):
                     destination.write('blurless = %s\n' % Blurless)
                 elif Line.startswith("taskswitcher"):
                    destination.write('taskswitcher = %s\n' % TaskSwitcher)
                 elif Line.startswith("zaxisrotation"):
                    destination.write('zaxisrotation = %s\n' % RotationAxis)
                 elif Line.startswith("forcerotation"):
                    destination.write('forcerotation = %s\n' % ForcedRotation)
                 elif Line.startswith("tactilepopups"):
                    destination.write('tactilepopups = %s\n' % Tactile)
                 else: 
                    destination.write( Line )
             source.close()
             destination.close()

             message = 'Updating system files. Please wait..'
             showQuickMessage(message)

             doUpdateConfigSystem()
             message = 'The new settings have been successfully saved.'
             
             #Update of the Theme config file (if it exists).
             if CheckFile(PathTheme,ConfigTheme) == True:

                 os.rename( PathTemp + ConfigTempTheme, PathTemp + ConfigTempTheme + "~" )
                 destination = open( PathTemp + ConfigTempTheme, "w" )
                 source = open( PathTemp + ConfigTempTheme + "~", "r" )
                 for Line in source:
                     if   Line.startswith("zoom_on_press"):
                         destination.write('zoom_on_press = %s\n' % ZoomPress)
                     elif Line.startswith("parallax"):
                         destination.write('parallax = %s\n' % Parallax)
                     elif Line.startswith("blurless"):
                         destination.write('blurless = %s\n' % Blurless)
                     elif Line.startswith("taskswitcher"):
                        destination.write('taskswitcher = %s\n' % TaskSwitcher)
                     elif Line.startswith("zaxisrotation"):
                        destination.write('zaxisrotation = %s\n' % RotationAxis)
                     elif Line.startswith("forcerotation"):
                        destination.write('forcerotation = %s\n' % ForcedRotation)
                     elif Line.startswith("tactilepopups"):
                        destination.write('tactilepopups = %s\n' % Tactile)
                     else: 
                        destination.write( Line )
                 source.close()
                 destination.close()
             
                 doUpdateConfigTheme()
                 message = 'The new settings have been successfully saved to the system and theme folders.'

             showMessage(message)
            
if __name__ == "__main__":
     
    ##Check with what priviledges the GUI has been executed
    if os.geteuid() == 0:
        message ='ERROR: The CSSU Features Configuration application cannot be executed as root. Exiting..'
        showMessage(message)
        sys.exit(1)

    ##Check if temp folder is available
    if os.path.exists(PathTemp) == False:
        os.system('mkdir %s' % PathTemp)
    else:
        pass
    
    os.system('cp %s %s' % (PathSystem + ConfigSystem, PathTemp + ConfigTempSystem))
    if CheckFile(PathTheme,ConfigTheme) == True: 
        os.system('cp %s %s' % (PathTheme + ConfigTheme, PathTemp + ConfigTempTheme))
        message = 'INFO: The application found a settings file in the theme folder.\nThe application will update both system and theme files with any changes requested.'
        showMessage(message)
        
    ##Open Dialog Window
    app = QtGui.QApplication(sys.argv)
    myapp = MyMainWindow()
    myapp.show()
    sys.exit(app.exec_())