#!/usr/bin/env python2.5
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
# MA  02110-1301, USA.
#

from distutils.core import setup

version = '0.3'

# files to install
inst_desktop = ['cservices.desktop']
inst_py = ['cservices.py', 'style.py', 'settings.py']
pixmaps = ['pixmaps/place.png', 'pixmaps/11870.png', 'pixmaps/defaultimg.png']
inst_modules = ['services/__init__.py', 'services/once.py', 'services/glocal.py']
inst_dbus = ['cservices.service']
#inst_icon = ['cservices.png']
backup_conf  = ['cservices.conf']
sh = ['cservices']

data_files = [
  ('share/applications/hildon', inst_desktop),
  ('/opt/cservices',   inst_py),
  ('/opt/cservices/pixmaps',   pixmaps),
  ('/opt/cservices/services',   inst_modules),
  ('share/dbus-1/services',   inst_dbus),
#  ('share/icons/hicolor/scalable/hildon/',   inst_icon),
  ('/etc/osso-backup/applications/',   backup_conf),
]

setup(
  name         = 'cservices',
  version      = version,
  description  = '11870.com client for Maemo',
  long_description = """CasualServices is a client for the services web 11870.com.
  Search and share your favorite services.""",
  author       = 'Daniel Martin Yerga',
  author_email = 'dyerga@gmail.com',
  url          = 'https://forja.rediris.es/projects/cusl4-cservices/',
  license      = 'GPL v2 or later at your election',
  platforms    = 'Maemo',
  data_files   = data_files,
  scripts      = sh
)
