# -*- coding: utf-8 -*-
# Copyright (C) 2009 by Daniel Martin Yerga <dyerga@gmail.com>
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
#
# CasualServices: Search and share your favourite places from 11870.com
import httplib2
import simplejson


#URLs used for searches
SEARCHURL="http://ajax.googleapis.com/ajax/services/search/local?v=1.0&q=%s&rsz=large&start=%s"


class GLocal:
    def __init__(self):
        pass

    def search(self, text, page):
        h = httplib2.Http()

        page = self.change_page(page)

        request, content = h.request(SEARCHURL % (text, page))

        content = simplejson.loads(content)
        points = content['responseData']['results']
        print points, '\n\n'

        return points

    def change_page(self, page):
        if page == '2':
            page = '10'
        elif page == '3':
            page = '20'
        elif page == '4':
            page = '30'
        elif page == '5':
            page = '40'
        elif page == '6':
            page = '50'
        elif page == '7':
            page = '60'
        elif page == '8':
            page = '70'
        elif page == '9':
            page = '80'
        elif page == '10':
            page = '90'

        return page
