/**
Copyright (c) 2012, DRAX <drax@drax.biz>
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

1. Redistributions of source code must retain the above copyright notice, this
   list of conditions and the following disclaimer.
2. Redistributions in binary form must reproduce the above copyright notice,
   this list of conditions and the following disclaimer in the documentation
   and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

The views and conclusions contained in the software and documentation are those
of the authors and should not be interpreted as representing official policies,
either expressed or implied, of the FreeBSD Project.
*/

// import QtQuick 1.0 // to target S60 5th Edition or Maemo 5
import QtQuick 1.1
import crosswords.LanguageLoader 1.0
import crosswords.ConfigurationManager 1.0
import "GeneralFunctions.js" as GF

Window
{
	id: window

	function initialize()
	{
		popup.clearQueue()
		popup.hideTextNow()
		setLanguage(configurationManager.getValue("language"), true)
		animationsEnabledButton.isChecked = GF.parseBool(configurationManager.getValue("animate"))
		smoothEnabledButton.isChecked = GF.parseBool(configurationManager.getValue("smooth"))
		soundsEnabledButton.isChecked = GF.parseBool(configurationManager.getValue("sounds"))
		askForQuitEnabledButton.isChecked = GF.parseBool(configurationManager.getValue("ask quit"))
		maxHighscoresValueBox.value = parseInt(configurationManager.getValue("crosswords max highscores"))
		nameInputText.text = configurationManager.getValue("name")
		return true
	}

	function getStateName()
	{
		return "Settings"
	}

	function setLanguage(lang, showJustRestartRequiredOPTIONAL)
	{
		languageListScroll.setSelectedValue(lang)

		if (languageLoader.getLanguage() != languageListScroll.getSelectedValue())
			if (showJustRestartRequiredOPTIONAL)
				popup.showText("<font color=\"#ff0000\">" + qsTr("Restart required") + "</font>")
			else
				popup.showText("<font color=\"#ff0000\">" + qsTr("Setting language requires restart") + "</font>")
	}

	onHidden:
	{
		popup.clearQueue()
		popup.hideTextNow()
	}

	Component.onCompleted:
	{
		var languagesArray = languageLoader.getAvailableLanguages()
		for (var i=0; i<languagesArray.length; i++)
			languageListScroll.addText(languagesArray[i])
	}

	ConfigurationManager
	{
		id: configurationManager
	}

	LanguageLoader
	{
		id: languageLoader
	}

	PopupInformation
	{
		id: popup

		doAnimations: window.doAnimations
		smooth: window.smooth
	}

	ListScroll
	{
		id: languageListScroll
		width: 220
		height: 414

		anchors.left: parent.left
		anchors.leftMargin: 10
		anchors.bottom: maxHighscoresValueBox.top
		anchors.bottomMargin: 10
		anchors.top: parent.top
		anchors.topMargin: languageText.height + languageText.anchors.bottomMargin * 2

		doAnimations: parent.doAnimations
		smooth: parent.smooth

		onSelectedValueChanged:
		{
			configurationManager.setValue("language", value)
			setLanguage(value)
		}
	}

	Text
	{
		id: languageText
		color: "#ffffff"
		text: qsTr("Language")
		anchors.horizontalCenter: languageListScroll.horizontalCenter
		anchors.bottom: languageListScroll.top
		anchors.bottomMargin: 10
		font.pixelSize: 30
	}

	ButtonCheckbox {
		id: animationsEnabledButton
		text: qsTr("Animate")
		anchors.left: languageListScroll.right
		anchors.leftMargin: 20
		mouseArea.onReleased: configurationManager.setValue("animate", isChecked)

		doAnimations: window.doAnimations
		smooth: window.smooth
	}

	ButtonCheckbox {
		id: smoothEnabledButton
		text: qsTr("Smooth")
		anchors.top: animationsEnabledButton.bottom
		anchors.topMargin: 10
		anchors.leftMargin: 20
		anchors.left: languageListScroll.right
		mouseArea.onReleased: configurationManager.setValue("smooth", isChecked)

		doAnimations: window.doAnimations
		smooth: window.smooth
	}

	ButtonCheckbox {
		id: soundsEnabledButton
		text: qsTr("Sounds")
		anchors.top: smoothEnabledButton.bottom
		anchors.topMargin: 10
		anchors.leftMargin: 20
		anchors.left: languageListScroll.right
		mouseArea.onReleased: configurationManager.setValue("sounds", isChecked)

		doAnimations: window.doAnimations
		smooth: window.smooth
	}

	ButtonCheckbox {
		id: askForQuitEnabledButton
		text: qsTr("Ask quit")
		anchors.top: soundsEnabledButton.bottom
		anchors.topMargin: 10
		anchors.leftMargin: 20
		anchors.left: languageListScroll.right
		mouseArea.onReleased: configurationManager.setValue("ask quit", isChecked)

		doAnimations: window.doAnimations
		smooth: window.smooth
	}

	Rectangle {
		id: nameRectangle
		x: 266
		y: 300
		width: askForQuitEnabledButton.width
		height: 40
		color: languageListScroll.color
		radius: 15
		anchors.top: askForQuitEnabledButton.bottom
		anchors.topMargin: 10
		anchors.leftMargin: 20
		anchors.left: languageListScroll.right

		smooth: window.smooth

		TextInput {
			id: nameInputText
			horizontalAlignment: TextInput.AlignHCenter
			anchors.rightMargin: 5
			anchors.leftMargin: 5
			anchors.bottomMargin: 5
			anchors.topMargin: 5
			anchors.fill: parent
			font.pixelSize: 25
			color: "#ffffff"

			onTextChanged: configurationManager.setValue("name", text)
		}
	}

	ValueBox {
		id: maxHighscoresValueBox
		min: 1
		max: 100
		anchors.leftMargin: 10
		anchors.left: parent.left
		anchors.bottom: parent.bottom
		anchors.bottomMargin: 10
		text: qsTr("Max highscores")

		onValueChanged: configurationManager.setValue("crosswords max highscores", value)

		doAnimations: window.doAnimations
		smooth: window.smooth
	}

}
