/**
Copyright (c) 2012, DRAX <drax@drax.biz>
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

1. Redistributions of source code must retain the above copyright notice, this
   list of conditions and the following disclaimer.
2. Redistributions in binary form must reproduce the above copyright notice,
   this list of conditions and the following disclaimer in the documentation
   and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

The views and conclusions contained in the software and documentation are those
of the authors and should not be interpreted as representing official policies,
either expressed or implied, of the FreeBSD Project.
*/

// import QtQuick 1.0 // to target S60 5th Edition or Maemo 5
import QtQuick 1.1

Window
{
	id: parentWindow

	property bool isInPortraitMode: false

	onOrientationLandscape:
	{
		isInPortraitMode = false
		window.state = "Landscape"
	}
	onOrientationPortrait:
	{
		isInPortraitMode = true
		window.state = "Portrait"
	}

	function getStateName()
	{
		return "Main"
	}

	//this is required to be centered  if it is resized (eg. window maximized)
	//in states are defined fixed dimensions
	Item
	{
		id: window

		property alias doAnimations: parentWindow.doAnimations
		property alias smooth: parentWindow.smooth

		anchors.verticalCenter: parentWindow.verticalCenter
		anchors.horizontalCenter: parentWindow.horizontalCenter

		Rectangle {
			id: multiplayerRectangle
			x: 409
			y: 19
			width: 376
			height: 442
			radius: 15
			Text {
				id: multiplayerText
				x: 17
				color: "#ffffff"
				text: qsTr("Multiplayer")
				font.pixelSize: 32
				anchors.horizontalCenter: parent.horizontalCenter
				anchors.top: parent.top
				anchors.topMargin: 0
				horizontalAlignment: Text.AlignHCenter
				verticalAlignment: Text.AlignVCenter
				transformOrigin: Item.Center
			}

			Button {
				id: joinButton
				x: 16
				y: 76
				width: 344
				height: 70
				text: qsTr("Join")

				doAnimations: window.doAnimations
				smooth: window.smooth

				anchors.horizontalCenter: parent.horizontalCenter
				anchors.horizontalCenterOffset: 0

				mouseArea.onReleased: setState(windowGameBrowser)
			}

			Button {
				id: hostButton
				x: 16
				y: 186
				width: 344
				height: 70
				text: qsTr("Host")

				doAnimations: window.doAnimations
				smooth: window.smooth

				anchors.horizontalCenter: parent.horizontalCenter
				anchors.horizontalCenterOffset: 0

				mouseArea.onReleased: setState(windowHostGame)
			}

			Button {
				id: optionsButton
				x: 16
				y: 356
				width: 344
				height: 70
				text: qsTr("Highscores")

				doAnimations: window.doAnimations
				smooth: window.smooth

				buttonColor: "#333300"
				anchors.horizontalCenter: parent.horizontalCenter
				anchors.horizontalCenterOffset: 0
				mouseArea.onReleased: setState(windowHighscores)
			}

			gradient: Gradient {
				GradientStop {
					position: 0
					color: "#ff3c3c3c"
				}

				GradientStop {
					position: 1
					color: "#00000000"
				}
			}
		}

		Rectangle {
			id: singleplayerRectangle
			x: 15
			y: 19
			width: 376
			height: 442
			radius: 15
			gradient: Gradient {
				GradientStop {
					id: gradientstop1
					position: 0
					color: "#ff3c3c3c"
				}

				GradientStop {
					position: 1
					color: "#00000000"
				}
			}

			Text {
				id: singleplayerText
				x: 17
				color: "#ffffff"
				text: qsTr("Singleplayer")
				transformOrigin: Item.Center
				anchors.top: parent.top
				anchors.topMargin: 0
				anchors.horizontalCenter: parent.horizontalCenter
				verticalAlignment: Text.AlignVCenter
				horizontalAlignment: Text.AlignHCenter
				font.pixelSize: 32
			}

			Button {
				id: singlewordButton
				x: 16
				y: 76
				width: 344
				height: 70
				text: qsTr("Single word")

				doAnimations: window.doAnimations
				smooth: window.smooth

				anchors.horizontalCenterOffset: 0
				anchors.horizontalCenter: parent.horizontalCenter
				mouseArea.onReleased: setState(windowSingleplayerSinglewordSettings)
			}

			Button {
				id: crossewordsButton
				x: 16
				y: 186
				width: 344
				height: 70
				text: qsTr("Crosswords")

				doAnimations: window.doAnimations
				smooth: window.smooth

				anchors.horizontalCenter: parent.horizontalCenter
				anchors.horizontalCenterOffset: 0
				mouseArea.onReleased: setState(windowSingleplayerCrosswordsSettings)
			}

			Button {
				id: highscoresButton
				x: 16
				y: 356
				width: 344
				height: 70
				text: qsTr("Options")

				doAnimations: window.doAnimations
				smooth: window.smooth

				buttonColor: "#333300"
				anchors.horizontalCenter: parent.horizontalCenter
				anchors.horizontalCenterOffset: 0
				mouseArea.onReleased: setState(windowSettings)
			}
		}

		TextDefault {
			id: emailTextDefault
			x: 371
			y: 333
			color: "#00c4ff"
			text: (parentWindow.isInPortraitMode ? "" : "Author: ") + "DRAX <drax@drax.biz> - " + (parentWindow.isInPortraitMode ? "" : "Year: ") + "2012"
			opacity: 0.300
			font.italic: true
			font.bold: true
			font.pointSize: 18
			anchors.bottom: parent.bottom
			anchors.bottomMargin: 0
			anchors.horizontalCenter: parent.horizontalCenter
		}

		states: [
			State {
			   name: "Landscape"

			   PropertyChanges
			   {
				   target: window
				   width: 800
				   height: 480
			   }

			   PropertyChanges {
				   target: singleplayerRectangle
				   x: 15
				   y: 19
			   }

			   PropertyChanges {
				   target: multiplayerRectangle
				   x: 409
				   y: 19
			   }

			   PropertyChanges {
				   target: highscoresButton
				   x: 16
				   y: 356
				   anchors.horizontalCenterOffset: 0
			   }

			   PropertyChanges {
				   target: optionsButton
				   x: 16
				   y: 356
				   anchors.horizontalCenterOffset: 0
			   }

			   PropertyChanges {
				   target: quitButton
				   x: 733
				   y: -5
			   }
			},
			State {
			   name: "Portrait"

			   PropertyChanges
			   {
				   target: window
				   width: 480
				   height: 800
			   }

			   PropertyChanges {
				   target: quitButton
				   x: 417
				   y: -6
			   }

			   PropertyChanges {
				   target: singleplayerRectangle
				   x: 52
				   y: 3
			   }

			   PropertyChanges {
				   target: multiplayerRectangle
				   x: 52
				   y: 408
			   }

			   PropertyChanges {
				   target: highscoresButton
				   x: 16
				   y: 298
				   anchors.horizontalCenterOffset: 0
			   }

			   PropertyChanges {
				   target: optionsButton
				   x: 16
				   y: 294
				   anchors.horizontalCenterOffset: 0
			   }
			}
		]
	}
}
