/**
Copyright (c) 2012, DRAX <drax@drax.biz>
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

1. Redistributions of source code must retain the above copyright notice, this
   list of conditions and the following disclaimer.
2. Redistributions in binary form must reproduce the above copyright notice,
   this list of conditions and the following disclaimer in the documentation
   and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

The views and conclusions contained in the software and documentation are those
of the authors and should not be interpreted as representing official policies,
either expressed or implied, of the FreeBSD Project.
*/

// import QtQuick 1.0 // to target S60 5th Edition or Maemo 5
import QtQuick 1.1

Rectangle
{
	id: listWidget

	property alias title: titleText.text
	property alias listWidth: listScroll.width
	property alias selectable: listScroll.selectable

	//signal emmits when score widget is hidden
	signal hidden(string selectedValue)

	property bool doAnimations: true

	function addItem(text)
	{
		listScroll.addText(text)
	}

	function setSelectedValue(value)
	{
		listScroll.setSelectedValue(value)
	}

	function clear()
	{
		listScroll.clear()
	}

	anchors.fill: parent
	color: "#33000000"
	opacity: 0
	z: 1000

	Behavior on opacity
	{
		NumberAnimation { duration: (doAnimations ? 200 : 0); easing.type: Easing.InOutQuad }
	}

	onOpacityChanged: if (opacity == 0) hidden(listScroll.getSelectedValue())

	//prevent mouse clicks outside of contentRectangle
	MouseArea
	{
		anchors.fill: parent

		onReleased: listWidget.opacity = 0
	}

	Rectangle
	{
		id: contentRectangle
		color: "#000000"
		radius: 7
		border.width: 2
		border.color: "#ffffff"
		anchors.top: parent.top
		anchors.bottom: parent.bottom
		anchors.horizontalCenter: parent.horizontalCenter
		anchors.margins: 50

		width: listWidth + 50

		smooth: parent.smooth

		Text
		{
			id: titleText
			color: "#ffffff"
			text: qsTr("TITLE")
			anchors.top: parent.top
			anchors.topMargin: 10
			anchors.horizontalCenter: parent.horizontalCenter
			font.bold: true
			font.pointSize: 24
			verticalAlignment: Text.AlignVCenter
			horizontalAlignment: Text.AlignHCenter
		}

		ListScroll
		{
			id: listScroll
			anchors.horizontalCenter: parent.horizontalCenter
			anchors.bottom: okButton.top
			anchors.bottomMargin: 10
			anchors.top: titleText.bottom
			anchors.topMargin: 10

			doAnimations: listWidget.doAnimations
			smooth: listWidget.smooth
		}

		Button
		{
			id: okButton
			height: 70
			text: qsTr("OK")
			anchors.bottom: parent.bottom
			anchors.bottomMargin: 10
			anchors.horizontalCenter: parent.horizontalCenter

			doAnimations: listWidget.doAnimations
			smooth: listWidget.smooth

			mouseArea.onReleased: listWidget.opacity = 0
		}
	}
}
