/**
Copyright (c) 2012, DRAX <drax@drax.biz>
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

1. Redistributions of source code must retain the above copyright notice, this
   list of conditions and the following disclaimer.
2. Redistributions in binary form must reproduce the above copyright notice,
   this list of conditions and the following disclaimer in the documentation
   and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

The views and conclusions contained in the software and documentation are those
of the authors and should not be interpreted as representing official policies,
either expressed or implied, of the FreeBSD Project.
*/

// import QtQuick 1.0 // to target S60 5th Edition or Maemo 5
import QtQuick 1.1

Rectangle
{
	id: confirmWidget

	property alias text: titleText.text
	property bool ok: false

	//signal emmits when score widget is hidden
	signal hidden(bool ok)

	property bool doAnimations: true

	anchors.fill: parent
	color: "#33000000"
	opacity: 0
	z: 1000

	Behavior on opacity
	{
		NumberAnimation { duration: (doAnimations ? 200 : 0); easing.type: Easing.InOutQuad }
	}

	onOpacityChanged:
	{
		if (opacity == 0)
		{
			hidden(ok)
			ok = false
		}
	}

	//prevent mouse clicks outside of contentRectangle
	MouseArea
	{
		anchors.fill: parent

		onReleased:
		{
			ok = false
			confirmWidget.opacity = 0
		}
	}

	Rectangle
	{
		id: contentRectangle
		color: "#000000"
		radius: 7
		border.width: 2
		border.color: "#ffffff"
		anchors.top: parent.top
		anchors.bottom: parent.bottom
		anchors.horizontalCenter: parent.horizontalCenter
		anchors.margins: 50

		width: 400

		smooth: parent.smooth

		Text
		{
			id: titleText
			color: "#ffffff"
			text: qsTr("TITLE")
			anchors.verticalCenterOffset: -50
			anchors.verticalCenter: parent.verticalCenter
			anchors.horizontalCenter: parent.horizontalCenter
			font.bold: true
			font.pointSize: 24
			verticalAlignment: Text.AlignVCenter
			horizontalAlignment: Text.AlignHCenter
		}

		Button
		{
			id: okButton
			y: 300
			width: 150
			height: 70
			text: qsTr("Yes")
			anchors.left: parent.left
			anchors.leftMargin: 20
			anchors.bottom: parent.bottom
			anchors.bottomMargin: 20

			doAnimations: confirmWidget.doAnimations
			smooth: confirmWidget.smooth

			mouseArea.onReleased:
			{
				ok = true
				confirmWidget.opacity = 0
			}
		}

		Button {
			id: cancelButton
			x: 0
			y: 300
			width: okButton.width
			height: 70
			text: qsTr("No")
			anchors.right: parent.right
			anchors.rightMargin: 20
			smooth: confirmWidget.smooth
			anchors.bottom: parent.bottom
			doAnimations: confirmWidget.doAnimations
			anchors.bottomMargin: 20

			mouseArea.onReleased:
			{
				ok = false
				confirmWidget.opacity = 0
			}
		}
	}
}
